/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.geotools.data.io.FeatureInputStream;
import de.riwagis.geotools.data.io.FeatureOutputStream;
import de.riwagis.geotools.feature.FidFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ZippedRenderIndex {
    private final Map<String, Integer> mapID = new HashMap<String, Integer>();
    private final Map<String, String> mapFidFeature = new HashMap<String, String>();
    private final SimpleFeatureType fType;
    private GZIPOutputStream zout = null;
    private ByteArrayOutputStream bout = null;
    private FeatureOutputStream fout = null;
    private int intSize = 0;
    private boolean bolBuild = false;
    private int intUseFidFeature = 0;
    private final boolean bolUseZipping = true;

    public ZippedRenderIndex(SimpleFeatureType _fType) {
        this.fType = _fType;
        this.clear();
    }

    public final void clear() {
        try {
            this.bout = new ByteArrayOutputStream();
            this.zout = new GZIPOutputStream(this.bout);
            this.fout = new FeatureOutputStream(this.zout, this.fType);
            this.bolBuild = false;
            this.mapID.clear();
            this.intSize = 0;
            this.intUseFidFeature = 0;
            this.mapFidFeature.clear();
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    public int size() {
        return this.intSize;
    }

    public void build() {
        try {
            if (this.bolBuild) {
                return;
            }
            this.bolBuild = true;
            this.fout.close();
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    private SimpleFeature unwrapFidFeature(SimpleFeature f) {
        switch (this.intUseFidFeature) {
            case 0: {
                if (f instanceof FidFeature) {
                    this.intUseFidFeature = 1;
                    SimpleFeature fDelegate = ((FidFeature)f).getDelegate();
                    this.mapFidFeature.put(fDelegate.getID(), f.getID());
                    return fDelegate;
                }
                this.intUseFidFeature = -1;
                return f;
            }
            case 1: {
                SimpleFeature fDelegate = ((FidFeature)f).getDelegate();
                this.mapFidFeature.put(fDelegate.getID(), f.getID());
                return fDelegate;
            }
            case -1: {
                return f;
            }
        }
        return f;
    }

    private SimpleFeature wrapFidFeature(SimpleFeature f) {
        switch (this.intUseFidFeature) {
            case 1: {
                return new FidFeature(f, this.mapFidFeature.get(f.getID()));
            }
            case -1: {
                return f;
            }
        }
        return f;
    }

    private FeatureInputStream getFeatureInputStream() {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.bout.toByteArray());
            return new FeatureInputStream(new GZIPInputStream(bin));
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    public void addFeature(SimpleFeature f) {
        try {
            if (this.bolBuild) {
                throw new IOException("Index is already build.");
            }
            f = this.unwrapFidFeature(f);
            this.mapID.put(f.getID(), this.intSize);
            this.fout.writeFeature(f);
            ++this.intSize;
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    public void addFeature(Envelope env, SimpleFeature f) {
        try {
            if (this.bolBuild) {
                throw new IOException("Index is already build.");
            }
            f = this.unwrapFidFeature(f);
            this.mapID.put(f.getID(), this.intSize);
            this.fout.writeFeature(f);
            ++this.intSize;
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    public Integer getPosition4Feature(SimpleFeature feat) {
        return this.mapID.get(feat.getID());
    }

    public SimpleFeature queryKey(String strKey) {
        try {
            if (!this.bolBuild) {
                this.build();
            }
            if (!this.mapID.containsKey(strKey)) {
                return null;
            }
            int intPos = this.mapID.get(strKey);
            FeatureInputStream fin = this.getFeatureInputStream();
            for (int intCurrentPos = 0; fin.hasNextFeature() && intPos > intCurrentPos; ++intCurrentPos) {
                fin.skipFeature();
            }
            if (!fin.hasNextFeature()) {
                Assert.shouldNeverReachHere();
            }
            return this.wrapFidFeature(fin.readFeature());
        }
        catch (IOException e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    public FeatureIterator<SimpleFeature> getFeaturesByPosition(final int[] arrPos) {
        if (!this.bolBuild) {
            this.build();
        }
        final FeatureInputStream fin = this.getFeatureInputStream();
        Arrays.sort(arrPos);
        return new FeatureIterator<SimpleFeature>(){
            private int posInArray = 0;
            private int posInFI = 0;

            public boolean hasNext() {
                return this.posInArray < arrPos.length;
            }

            public SimpleFeature next() {
                try {
                    int nextPosInFI = arrPos[this.posInArray];
                    while (this.posInFI < nextPosInFI) {
                        fin.skipFeature();
                        ++this.posInFI;
                    }
                    SimpleFeature f = fin.readFeature();
                    ++this.posInFI;
                    ++this.posInArray;
                    return ZippedRenderIndex.this.wrapFidFeature(f);
                }
                catch (Exception e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                    return null;
                }
            }

            public void close() {
                try {
                    fin.close();
                }
                catch (Exception e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                }
            }
        };
    }

    public FeatureIterator<SimpleFeature> query(final Envelope env) {
        if (!this.bolBuild) {
            this.build();
        }
        final FeatureInputStream fin = this.getFeatureInputStream();
        return new FeatureIterator<SimpleFeature>(){
            private SimpleFeature fCandidate = null;
            private boolean bolNextCalled = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean hasNext() {
                try {
                    if (this.bolNextCalled) {
                        if (this.fCandidate == null) return false;
                        return true;
                    }
                    try {
                        if (!fin.hasNextFeature()) {
                            this.fCandidate = null;
                            boolean bl = false;
                            return bl;
                        }
                        while (fin.hasNextFeature()) {
                            Geometry geom;
                            this.fCandidate = fin.readFeature();
                            Object objGeom = this.fCandidate.getDefaultGeometry();
                            if (objGeom == null || (geom = (Geometry)objGeom).isEmpty() || !geom.getEnvelopeInternal().intersects(env)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        this.fCandidate = null;
                        boolean objGeom = false;
                        return objGeom;
                    }
                    finally {
                        this.bolNextCalled = true;
                    }
                }
                catch (Exception e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                    return false;
                }
            }

            public SimpleFeature next() {
                try {
                    if (!this.bolNextCalled) {
                        this.hasNext();
                    }
                    SimpleFeature simpleFeature = ZippedRenderIndex.this.wrapFidFeature(this.fCandidate);
                    return simpleFeature;
                }
                catch (Exception e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                    SimpleFeature simpleFeature = null;
                    return simpleFeature;
                }
                finally {
                    this.bolNextCalled = false;
                }
            }

            public void close() {
                try {
                    fin.close();
                }
                catch (Exception e) {
                    Assert.shouldNeverReachHere((String)e.getMessage());
                }
            }
        };
    }
}

