/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.crs.Transformer;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class TransformingFeatureIterator
implements FeatureIterator<SimpleFeature> {
    private final Transformer trans;
    private final FeatureIterator<SimpleFeature> fi;

    public TransformingFeatureIterator(FeatureIterator<SimpleFeature> _fi, Transformer _trans) {
        this.trans = _trans;
        this.fi = _fi;
    }

    public boolean hasNext() {
        return this.fi.hasNext();
    }

    public SimpleFeature next() {
        SimpleFeature feat = (SimpleFeature)this.fi.next();
        try {
            if (feat.getDefaultGeometry() != null) {
                this.trans.transform2d(feat);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not transform feature", e);
        }
        return feat;
    }

    public void close() {
        this.fi.close();
    }
}

