/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.util.rendering.index.RectSTRtree;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opengis.feature.simple.SimpleFeature;

public class ShapeFeatureSTRtree {
    private final RectSTRtree index = new RectSTRtree();
    public static final ShapeFeatureSTRtree DUMMY_SHAPEFEATURESTRTREE = new ShapeFeatureSTRtree(){

        @Override
        public void insert(Shape shp, SimpleFeature feat, RenderPointSpec spec) {
        }

        @Override
        public void insert(Shape shp, SimpleFeature feat, RenderPointSpec spec, boolean bolUseShape) {
        }

        @Override
        public void insert(Shape[] arrShp, SimpleFeature feat, RenderPointSpec spec, boolean bolUseShape) {
        }

        @Override
        public void insert(Shape[] arrShp, SimpleFeature feat, RenderPointSpec spec) {
        }

        @Override
        public void build() {
        }

        @Override
        public List<Shape> queryShapes(Rectangle2D env) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<Object> queryFeatures(Rectangle2D env) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<Object> query(Rectangle2D env) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int depth() {
            return 0;
        }
    };

    public void build() {
        this.index.build();
    }

    public int depth() {
        return this.index.depth();
    }

    private Rectangle2D getIndexRectangle(Shape shp) {
        Rectangle2D env = shp.getBounds2D();
        if ((int)env.getWidth() == 0) {
            env.add(env.getMaxX() + 1.0, env.getMaxY());
        }
        if ((int)env.getHeight() == 0) {
            env.add(env.getMaxX(), env.getMaxY() + 1.0);
        }
        return env;
    }

    public void insert(Shape shp, SimpleFeature feat, RenderPointSpec spec) {
        Rectangle2D env = this.getIndexRectangle(shp);
        Object[] arrObj = new Object[]{null, feat, spec, null};
        this.index.insert(env, (Object)arrObj);
    }

    public void insert(Shape shp, SimpleFeature feat, RenderPointSpec spec, boolean bolUseShape) {
        Rectangle2D env = this.getIndexRectangle(shp);
        Object[] arrObj = bolUseShape ? new Object[]{new Shape[]{shp}, feat, spec} : new Object[]{null, feat, spec};
        this.index.insert(env, (Object)arrObj);
    }

    public void insert(Shape[] arrShp, SimpleFeature feat, RenderPointSpec spec) {
        this.insert(arrShp, feat, spec, false);
    }

    public void insert(Shape[] arrShp, SimpleFeature feat, RenderPointSpec spec, boolean bolUseShape) {
        if (arrShp == null) {
            return;
        }
        Rectangle2D env = null;
        for (Shape arrShp1 : arrShp) {
            if (arrShp1 == null) continue;
            if (env == null) {
                env = this.getIndexRectangle(arrShp1);
                continue;
            }
            env.add(this.getIndexRectangle(arrShp1));
        }
        if (env == null) {
            return;
        }
        Object[] arrObj = bolUseShape ? new Object[]{arrShp, feat, spec} : new Object[]{null, feat, spec};
        this.index.insert(env, (Object)arrObj);
    }

    public int size() {
        return this.index.size();
    }

    public List<Object> query(Rectangle2D env) {
        return this.index.query(env);
    }

    public List<Object> queryFeatures(Rectangle2D env) {
        ArrayList<Object> lstReturn = new ArrayList<Object>();
        for (Object currQR : this.query(env)) {
            Object[] arrObj = (Object[])currQR;
            lstReturn.add(arrObj[1]);
        }
        return lstReturn;
    }

    public List<Shape> queryShapes(Rectangle2D env) {
        ArrayList<Shape> lstReturn = new ArrayList<Shape>();
        for (Object currQR : this.query(env)) {
            Object[] arrObj = (Object[])currQR;
            Shape[] arrShp = (Shape[])arrObj[0];
            lstReturn.addAll(Arrays.asList(arrShp));
        }
        return lstReturn;
    }
}

