/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.geotools.feature.RenderType;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Geometry;

public class RenderPointSpec {
    private final RenderType renderType;
    private final Point2D centerPoint;
    private final double orientation;
    private final Geometry source;

    public RenderPointSpec(RenderType renderType, Point2D centerPoint, double orientation, Geometry source) {
        this.renderType = renderType;
        this.centerPoint = centerPoint;
        this.orientation = orientation;
        this.source = source;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public Point2D getCenterPoint() {
        return this.centerPoint;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public Geometry getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderPointSpec)) {
            return false;
        }
        RenderPointSpec other = (RenderPointSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getOrientation(), other.getOrientation()) != 0) {
            return false;
        }
        RenderType this$renderType = this.getRenderType();
        RenderType other$renderType = other.getRenderType();
        if (this$renderType == null ? other$renderType != null : !((Object)((Object)this$renderType)).equals((Object)other$renderType)) {
            return false;
        }
        Point2D this$centerPoint = this.getCenterPoint();
        Point2D other$centerPoint = other.getCenterPoint();
        if (this$centerPoint == null ? other$centerPoint != null : !((Object)this$centerPoint).equals(other$centerPoint)) {
            return false;
        }
        Geometry this$source = this.getSource();
        Geometry other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderPointSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $orientation = Double.doubleToLongBits(this.getOrientation());
        result = result * 59 + (int)($orientation >>> 32 ^ $orientation);
        RenderType $renderType = this.getRenderType();
        result = result * 59 + ($renderType == null ? 43 : ((Object)((Object)$renderType)).hashCode());
        Point2D $centerPoint = this.getCenterPoint();
        result = result * 59 + ($centerPoint == null ? 43 : ((Object)$centerPoint).hashCode());
        Geometry $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String toString() {
        return "RenderPointSpec(renderType=" + this.getRenderType() + ", centerPoint=" + this.getCenterPoint() + ", orientation=" + this.getOrientation() + ", source=" + this.getSource() + ")";
    }
}

