/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class OrderByFeatureIterator
implements FeatureIterator {
    private final Iterator<SimpleFeature> iFeat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderByFeatureIterator(FeatureIterator<SimpleFeature> featureIterator, String _strOrderByCol, boolean _bolDesc) {
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        try {
            while (featureIterator.hasNext()) {
                lstFeatures.add((SimpleFeature)featureIterator.next());
            }
        }
        finally {
            featureIterator.close();
        }
        FeatureComparator comp = new FeatureComparator(_strOrderByCol, _bolDesc);
        Collections.sort(lstFeatures, comp);
        this.iFeat = lstFeatures.iterator();
    }

    public void close() {
    }

    public boolean hasNext() {
        return this.iFeat.hasNext();
    }

    public SimpleFeature next() {
        return this.iFeat.next();
    }

    private class FeatureComparator
    implements Comparator<SimpleFeature> {
        private String strOrderByCol = null;
        private boolean bolDesc = false;

        private FeatureComparator(String _strOrderByCol, boolean _bolDesc) {
            this.strOrderByCol = _strOrderByCol;
            this.bolDesc = _bolDesc;
        }

        @Override
        public int compare(SimpleFeature o1, SimpleFeature o2) {
            Object compO2;
            if (o1 == o2) {
                return 0;
            }
            Object compO1 = FeatureUtil.getAttribute(o1, this.strOrderByCol);
            if (compO1 == (compO2 = FeatureUtil.getAttribute(o2, this.strOrderByCol))) {
                return 0;
            }
            if (this.bolDesc) {
                if (compO1 == null) {
                    return 1;
                }
                if (compO2 == null) {
                    return -1;
                }
                if (compO1 instanceof Number && compO2 instanceof Number) {
                    return ((Number)compO2).intValue() - ((Number)compO1).intValue();
                }
                return 0;
            }
            if (compO1 == null) {
                return -1;
            }
            if (compO2 == null) {
                return 1;
            }
            if (compO1 instanceof Number && compO2 instanceof Number) {
                return ((Number)compO1).intValue() - ((Number)compO2).intValue();
            }
            return 0;
        }
    }
}

