/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;

public class GeomFeatureSTRtree_new {
    private final STRtree index = new STRtree();
    private static final GeometryFactory factory = new GeometryFactory();

    public void build() {
        this.index.build();
    }

    public int depth() {
        return this.index.depth();
    }

    public void insert(SimpleFeature feat) {
        Geometry geom = (Geometry)feat.getDefaultGeometry();
        Envelope env = geom.getEnvelopeInternal();
        Object[] arrObj = new Object[]{geom, feat};
        this.index.insert(env, (Object)arrObj);
    }

    public void insert(double x1, double y1, double x2, double y2, double width, SimpleFeature feat) {
        RenderRectangle rect = new RenderRectangle(x1, y1, x2, y2, width);
        Object[] arrObj = new Object[]{rect, feat};
        this.index.insert(rect.getEnvelopeInternal(), (Object)arrObj);
    }

    public int size() {
        return this.index.size();
    }

    public List<Object> query(Envelope env) {
        List lst = this.index.query(env);
        ArrayList<Object> lstReturn = new ArrayList<Object>();
        for (Object[] arrObj : lst) {
            if (arrObj[0] instanceof RenderRectangle) {
                Geometry geom = ((RenderRectangle)arrObj[0]).getGeometry();
                Object[] arrObjReturn = new Object[]{geom, arrObj[1]};
                lstReturn.add(arrObjReturn);
                continue;
            }
            lstReturn.add(arrObj);
        }
        return lstReturn;
    }

    public List<Object> queryFeatures(Envelope env) {
        List lst = this.index.query(env);
        ArrayList<Object> lstReturn = new ArrayList<Object>();
        for (Object[] arrObj : lst) {
            lstReturn.add(arrObj[1]);
        }
        return lstReturn;
    }

    public class RenderRectangle {
        private Envelope env = null;
        private final double v;
        private final double width;

        public RenderRectangle(double x1, double y1, double x2, double y2, double _width) {
            this.width = _width;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.v = Math.abs(dy / dx);
            double length = Math.sqrt(dx * dx + dy * dy);
            double dxenv = dy * this.width / 2.0 / length;
            double dyenv = dx * this.width / 2.0 / length;
            double xmin = Math.min(x1, x2) - Math.abs(dxenv);
            double ymin = Math.min(y1, y2) - Math.abs(dyenv);
            double xmax = Math.max(x1, x2) + Math.abs(dxenv);
            double ymax = Math.max(y1, y2) + Math.abs(dyenv);
            this.env = new Envelope(xmin, xmax, ymin, ymax);
        }

        public Geometry getGeometry() {
            double dy = Math.sqrt(this.width * this.width / (this.v * this.v + 1.0));
            double dx = Math.abs(dy * this.v);
            Coordinate[] arrCoordinate = new Coordinate[5];
            if (this.v < 0.0) {
                arrCoordinate[0] = new Coordinate(this.env.getMinX(), this.env.getMaxY() - dy);
                arrCoordinate[1] = new Coordinate(this.env.getMinX() + dx, this.env.getMaxY());
                arrCoordinate[2] = new Coordinate(this.env.getMaxX(), this.env.getMinY() + dy);
                arrCoordinate[3] = new Coordinate(this.env.getMaxX() - dx, this.env.getMinY());
                arrCoordinate[4] = arrCoordinate[0];
            } else {
                arrCoordinate[0] = new Coordinate(this.env.getMinX() + dx, this.env.getMinY());
                arrCoordinate[1] = new Coordinate(this.env.getMinX(), this.env.getMinY() + dy);
                arrCoordinate[2] = new Coordinate(this.env.getMaxX() - dx, this.env.getMaxY());
                arrCoordinate[3] = new Coordinate(this.env.getMaxX(), this.env.getMaxY() - dy);
                arrCoordinate[4] = arrCoordinate[0];
            }
            return factory.createPolygon(factory.createLinearRing(arrCoordinate), new LinearRing[0]);
        }

        public Envelope getEnvelopeInternal() {
            return this.env;
        }
    }
}

