/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;

public class GeomFeatureSTRtree {
    private final STRtree index = new STRtree();

    public void build() {
        this.index.build();
    }

    public int depth() {
        return this.index.depth();
    }

    public void insert(SimpleFeature feat) {
        this.insert((Geometry)feat.getDefaultGeometry(), feat);
    }

    public void insert(Geometry geom, SimpleFeature feat) {
        Envelope env = geom.getEnvelopeInternal();
        Object[] arrObj = new Object[]{geom, feat};
        this.index.insert(env, (Object)arrObj);
    }

    public int size() {
        return this.index.size();
    }

    public List<Object[]> query(Envelope env) {
        return this.index.query(env);
    }

    public List<SimpleFeature> queryFeatures(Envelope env) {
        ArrayList<SimpleFeature> lstReturn = new ArrayList<SimpleFeature>();
        for (Object[] arrObj : this.query(env)) {
            lstReturn.add((SimpleFeature)arrObj[1]);
        }
        return lstReturn;
    }

    public List<Geometry> queryGeometries(Envelope env) {
        ArrayList<Geometry> lstReturn = new ArrayList<Geometry>();
        for (Object[] arrObj : this.query(env)) {
            lstReturn.add((Geometry)arrObj[0]);
        }
        return lstReturn;
    }
}

