/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureReaderIterator<T extends FeatureType, F extends Feature>
implements FeatureIterator<F> {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureReaderIterator.class);
    private final FeatureReader<T, F> fread;

    public FeatureReaderIterator(FeatureReader<T, F> _fread) {
        this.fread = _fread;
    }

    public void close() {
        if (this.fread != null) {
            try {
                this.fread.close();
            }
            catch (Exception e) {
                LOG.warn("Error while Reading Features", (Throwable)e);
                throw new RuntimeException("Error while Reading Features", e);
            }
        }
    }

    public boolean hasNext() {
        if (this.fread != null) {
            try {
                return this.fread.hasNext();
            }
            catch (Exception e) {
                LOG.warn("Error while Reading Features", (Throwable)e);
                throw new RuntimeException("Error while Reading Features", e);
            }
        }
        return false;
    }

    public F next() {
        if (this.fread != null) {
            try {
                return (F)this.fread.next();
            }
            catch (Exception e) {
                LOG.warn("Error while Reading Features", (Throwable)e);
                throw new RuntimeException("Error while Reading Features", e);
            }
        }
        return null;
    }

    public T getFeatureType() {
        return (T)(this.fread == null ? null : this.fread.getFeatureType());
    }
}

