/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public class AreaLinePointFeatureIterator
implements FeatureIterator<SimpleFeature> {
    private final List<SimpleFeature> lstLines = new ArrayList<SimpleFeature>();
    private final List<SimpleFeature> lstSyms = new ArrayList<SimpleFeature>();
    private final List<SimpleFeature> lstTexts = new ArrayList<SimpleFeature>();
    private Iterator<SimpleFeature> iLines = null;
    private Iterator<SimpleFeature> iSyms = null;
    private Iterator<SimpleFeature> iTexts = null;
    private FeatureIterator<SimpleFeature> i = null;
    private boolean bolNextCalled = false;
    private boolean bolNext = true;
    private SimpleFeature featNext = null;

    public AreaLinePointFeatureIterator(FeatureIterator<SimpleFeature> _i) {
        this.i = _i;
    }

    public void close() {
        this.i.close();
    }

    public boolean hasNext() {
        if (!this.bolNextCalled) {
            this.bolNextCalled = true;
            this.bolNext = this.i.hasNext();
            if (this.bolNext) {
                this.featNext = (SimpleFeature)this.i.next();
                Geometry geom = (Geometry)this.featNext.getDefaultGeometry();
                if (geom == null) {
                    return true;
                }
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    if (FeatureUtil.hasAttribute(this.featNext, "text") && ObjectUtils.toString((Object)FeatureUtil.getAttribute(this.featNext, "text")).length() > 0) {
                        this.lstTexts.add(this.featNext);
                        return this.hasNext();
                    }
                    this.lstSyms.add(this.featNext);
                    return this.hasNext();
                }
                if (geom instanceof LineString || geom instanceof MultiLineString) {
                    this.lstLines.add(this.featNext);
                    return this.hasNext();
                }
                return true;
            }
            if (this.iLines == null) {
                this.iLines = this.lstLines.iterator();
            }
            this.bolNext = this.iLines.hasNext();
            if (this.bolNext) {
                this.featNext = this.iLines.next();
                return true;
            }
            if (this.iSyms == null) {
                this.iSyms = this.lstSyms.iterator();
            }
            this.bolNext = this.iSyms.hasNext();
            if (this.bolNext) {
                this.featNext = this.iSyms.next();
                return true;
            }
            if (this.iTexts == null) {
                this.iTexts = this.lstTexts.iterator();
            }
            this.bolNext = this.iTexts.hasNext();
            if (this.bolNext) {
                this.featNext = this.iTexts.next();
                return true;
            }
            return this.bolNext;
        }
        return this.bolNext;
    }

    public SimpleFeature next() {
        try {
            if (!this.bolNext) {
                SimpleFeature simpleFeature = null;
                return simpleFeature;
            }
            if (!this.bolNextCalled) {
                this.hasNext();
            }
            SimpleFeature simpleFeature = this.featNext;
            return simpleFeature;
        }
        finally {
            this.bolNextCalled = false;
        }
    }
}

