/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.envelope;

import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopeUtil {
    public static final ReferencedEnvelope readReferencedEnvelope(String envString) throws FactoryException {
        return EnvelopeUtil.readReferencedEnvelope(envString, "\\|");
    }

    public static final ReferencedEnvelope readReferencedEnvelope(String envString, String separator) throws FactoryException {
        ReferencedEnvelope env;
        if (StringUtils.isEmpty((CharSequence)envString)) {
            env = new ReferencedEnvelope();
        } else {
            String[] arrBBOX = envString.split(separator);
            CoordinateReferenceSystem crs = null;
            if (arrBBOX.length == 5 && StringUtils.isNotEmpty((CharSequence)arrBBOX[4])) {
                crs = CRS.decode((String)arrBBOX[4]);
            }
            double minX = Double.parseDouble(arrBBOX[0]);
            double minY = Double.parseDouble(arrBBOX[1]);
            double maxX = Double.parseDouble(arrBBOX[2]);
            double maxY = Double.parseDouble(arrBBOX[3]);
            env = minX > maxX || minY > maxY ? new ReferencedEnvelope(crs) : new ReferencedEnvelope(minX, maxX, minY, maxY, crs);
        }
        return env;
    }

    public static final String writeReferencedEnvelope(ReferencedEnvelope env) {
        if (env == null) {
            env = new ReferencedEnvelope();
        }
        StringBuilder sbBBOX = new StringBuilder();
        sbBBOX.append(env.getMinX()).append("|");
        sbBBOX.append(env.getMinY()).append("|");
        sbBBOX.append(env.getMaxX()).append("|");
        sbBBOX.append(env.getMaxY());
        if (env.getCoordinateReferenceSystem() != null) {
            sbBBOX.append("|").append(CRS.toSRS((CoordinateReferenceSystem)env.getCoordinateReferenceSystem()));
        }
        return sbBBOX.toString();
    }

    public static void roundEnvelope(Envelope env, double ac) {
        double moduloMaxY;
        double minX = env.getMinX();
        double minY = env.getMinY();
        double maxX = env.getMaxX();
        double maxY = env.getMaxY();
        minX -= minX % ac;
        minY -= minY % ac;
        double moduloMaxX = maxX % ac;
        if (moduloMaxX > 0.0) {
            maxX = maxX - moduloMaxX + ac;
        }
        if ((moduloMaxY = maxY % ac) > 0.0) {
            maxY = maxY - moduloMaxY + ac;
        }
        env.init(minX, maxX, minY, maxY);
    }
}

