/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.util.Assert;

public class OffsetGeomWriter
extends WKBWriter {
    public static final int DEFAULT_BYTEORDER = 1;
    private final int outputDimension;
    private final int byteOrder;
    private final ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
    private final OutStream byteArrayOutStream = new OutputStreamOutStream((OutputStream)this.byteArrayOS);
    private final byte[] buf = new byte[4];
    private final double dbl_offset_x;
    private final double dbl_offset_y;

    public OffsetGeomWriter(double dbl_offset_x, double dbl_offset_y) {
        this(dbl_offset_x, dbl_offset_y, 2, 1);
    }

    public OffsetGeomWriter(double dbl_offset_x, double dbl_offset_y, int outputDimension) {
        this(dbl_offset_x, dbl_offset_y, outputDimension, 1);
    }

    public OffsetGeomWriter(double dbl_offset_x, double dbl_offset_y, int outputDimension, int byteOrder) {
        this.outputDimension = outputDimension;
        this.byteOrder = byteOrder;
        this.dbl_offset_x = dbl_offset_x;
        this.dbl_offset_y = dbl_offset_y;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public byte[] write(Geometry geom) {
        try {
            this.byteArrayOS.reset();
            this.write(geom, this.byteArrayOutStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.byteArrayOS.toByteArray();
    }

    public void write(Geometry geom, OutStream os) throws IOException {
        if (geom instanceof Point) {
            this.writePoint((Point)geom, os);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, os);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, os);
        } else if (geom instanceof MultiPoint) {
            this.writeGeometryCollection(4, (GeometryCollection)geom, os);
        } else if (geom instanceof MultiLineString) {
            this.writeGeometryCollection(5, (GeometryCollection)geom, os);
        } else if (geom instanceof MultiPolygon) {
            this.writeGeometryCollection(6, (GeometryCollection)geom, os);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection(7, (GeometryCollection)geom, os);
        } else {
            Assert.shouldNeverReachHere((String)"Unknown Geometry type");
        }
    }

    private void writePoint(Point pt, OutStream os) throws IOException {
        if (pt.getCoordinateSequence().size() == 0) {
            throw new IllegalArgumentException("Empty Points cannot be represented in WKB");
        }
        this.writeByteOrder(os);
        this.writeGeometryType(1, os);
        this.writeCoordinateSequence(pt.getCoordinateSequence(), false, os);
    }

    private void writeLineString(LineString line, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(2, os);
        this.writeCoordinateSequence(line.getCoordinateSequence(), true, os);
    }

    private void writePolygon(Polygon poly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(3, os);
        this.writeInt(poly.getNumInteriorRing() + 1, os);
        this.writeCoordinateSequence(poly.getExteriorRing().getCoordinateSequence(), true, os);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.writeCoordinateSequence(poly.getInteriorRingN(i).getCoordinateSequence(), true, os);
        }
    }

    private void writeGeometryCollection(int geometryType, GeometryCollection gc, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, os);
        this.writeInt(gc.getNumGeometries(), os);
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            this.write(gc.getGeometryN(i), os);
        }
    }

    private void writeByteOrder(OutStream os) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : 0;
        os.write(this.buf, 1);
    }

    private void writeGeometryType(int geometryType, OutStream os) throws IOException {
        int flag3D = this.outputDimension == 3 ? Integer.MIN_VALUE : 0;
        int typeInt = geometryType | flag3D;
        this.writeInt(typeInt, os);
    }

    private void writeInt(int intValue, OutStream os) throws IOException {
        ByteOrderValues.putInt((int)intValue, (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 4);
    }

    private void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) throws IOException {
        if (writeSize) {
            this.writeInt(seq.size(), os);
        }
        for (int i = 0; i < seq.size(); ++i) {
            this.writeCoordinate(seq, i, os);
        }
    }

    private void writeCoordinate(CoordinateSequence seq, int index, OutStream os) throws IOException {
        float x = (float)(seq.getX(index) - this.dbl_offset_x);
        float y = (float)(seq.getY(index) - this.dbl_offset_y);
        OffsetGeomWriter.putFloat(x, this.buf, this.byteOrder);
        os.write(this.buf, 4);
        OffsetGeomWriter.putFloat(y, this.buf, this.byteOrder);
        os.write(this.buf, 4);
        if (this.outputDimension >= 3) {
            float ordVal = Float.NaN;
            if (seq.getDimension() >= 3) {
                ordVal = (float)seq.getOrdinate(index, 2);
            }
            OffsetGeomWriter.putFloat(ordVal, this.buf, this.byteOrder);
            os.write(this.buf, 4);
        }
    }

    public static double getFloat(byte[] buf, int byteOrder) {
        int intVal = ByteOrderValues.getInt((byte[])buf, (int)byteOrder);
        return Float.intBitsToFloat(intVal);
    }

    public static void putFloat(float floatValue, byte[] buf, int byteOrder) {
        int intVal = Float.floatToIntBits(floatValue);
        ByteOrderValues.putInt((int)intVal, (byte[])buf, (int)byteOrder);
    }
}

