/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.io;

import java.io.IOException;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class OffsetGeomReader
extends WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private GeometryFactory factory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private boolean hasSRID = false;
    private int SRID = 0;
    private final ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;
    private final double[] dbl_offset;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = OffsetGeomReader.hexToInt(hex.charAt(i2));
            int nib0 = OffsetGeomReader.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public OffsetGeomReader(double dbl_offset_x, double dbl_offset_y) {
        this(dbl_offset_x, dbl_offset_y, new GeometryFactory());
    }

    public OffsetGeomReader(double dbl_offset_x, double dbl_offset_y, GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.dbl_offset = new double[]{dbl_offset_x, dbl_offset_y, 0.0};
        this.precisionModel = this.factory.getPrecisionModel();
    }

    public Geometry read(byte[] bytes) throws ParseException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public Geometry read(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        Geometry g = this.readGeometry();
        this.setSRID(g);
        return g;
    }

    private Geometry readGeometry() throws IOException, ParseException {
        byte byteOrder = this.dis.readByte();
        if (byteOrder == 1) {
            this.dis.setOrder(2);
        }
        int typeInt = this.dis.readInt();
        int geometryType = typeInt & 0xFF;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        this.inputDimension = hasZ ? 3 : 2;
        boolean bl = this.hasSRID = (typeInt & 0x20000000) != 0;
        if (this.hasSRID) {
            this.SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        switch (geometryType) {
            case 1: {
                return this.readPoint();
            }
            case 2: {
                return this.readLineString();
            }
            case 3: {
                return this.readPolygon();
            }
            case 4: {
                return this.readMultiPoint();
            }
            case 5: {
                return this.readMultiLineString();
            }
            case 6: {
                return this.readMultiPolygon();
            }
            case 7: {
                return this.readGeometryCollection();
            }
        }
        throw new ParseException("Unknown WKB type " + geometryType);
    }

    private Geometry setSRID(Geometry g) {
        if (this.SRID != 0) {
            g.setSRID(this.SRID);
        }
        return g;
    }

    private Point readPoint() throws IOException, ParseException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException, ParseException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLineString(pts);
    }

    private LinearRing readLinearRing() throws IOException, ParseException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLinearRing(pts);
    }

    private Polygon readPolygon() throws IOException, ParseException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        for (int i = 0; i < numRings - 1; ++i) {
            holes[i] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Point[] geoms = new Point[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i] = (Point)g;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        LineString[] geoms = new LineString[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i] = (LineString)g;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Polygon[] geoms = new Polygon[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i] = (Polygon)g;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Geometry[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry();
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.factory.getCoordinateSequenceFactory().create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            for (int j = 0; j < targetDim; ++j) {
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private void readCoordinate() throws IOException, ParseException {
        for (int i = 0; i < this.inputDimension; ++i) {
            int intVal = this.dis.readInt();
            float fltVal = Float.intBitsToFloat(intVal);
            double dblVal = this.dbl_offset[i] + (double)fltVal;
            this.ordValues[i] = i <= 1 ? this.precisionModel.makePrecise(dblVal) : dblVal;
        }
    }
}

