/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.io;

import de.riwagis.geotools.data.io.FeatureStreamSupport;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOutputStream
extends DataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureOutputStream.class);
    public static final String FTYPE_GEOM_ALWAYS_NULLABLE = "FTYPE_IGNORE_GEOM_NULLABLE";
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    private final WKBWriter wkbWriter = new WKBWriter(3);
    private final SimpleFeatureType fType;
    private final int intVersion;
    private byte[] arrTypes = null;
    private boolean endMarkWritten;

    public FeatureOutputStream(OutputStream _out, SimpleFeatureType _fType) throws IOException {
        this(_out, _fType, 0);
    }

    public FeatureOutputStream(OutputStream _out, SimpleFeatureType _fType, int _intVersion) throws IOException {
        super(_out);
        this.intVersion = _intVersion;
        if (this.intVersion < 0 || this.intVersion > 3) {
            throw new IOException("Invalid stream version");
        }
        this.fType = _fType;
        this.writeHeader();
        this.endMarkWritten = false;
    }

    public SimpleFeatureType getFeatureType() {
        return this.fType;
    }

    private void writeHeader() throws IOException {
        this.writeByte(126);
        this.writeInt(this.intVersion);
        this.writeUTF(this.fType.getName().getLocalPart());
        this.writeUTF(this.fType.getName().getNamespaceURI());
        this.writeSRS(this.fType.getCoordinateReferenceSystem());
        this.writeInt(this.fType.getAttributeCount());
        boolean ignoreGeomNullable = false;
        if (this.fType.getUserData().containsKey(FTYPE_GEOM_ALWAYS_NULLABLE)) {
            ignoreGeomNullable = (Boolean)this.fType.getUserData().get(FTYPE_GEOM_ALWAYS_NULLABLE);
        }
        AttributeDescriptor[] arrType = this.fType.getAttributeDescriptors().toArray(new AttributeDescriptor[0]);
        this.arrTypes = new byte[arrType.length];
        for (int i = 0; i < arrType.length; ++i) {
            this.writeByte(125);
            this.writeUTF(arrType[i].getName().getLocalPart());
            this.arrTypes[i] = FeatureStreamSupport.getByteType(arrType[i].getType().getBinding());
            this.writeByte(this.arrTypes[i]);
            if (FeatureStreamSupport.isGeometryType(this.arrTypes[i]) && ignoreGeomNullable) {
                this.writeBoolean(true);
            } else {
                this.writeBoolean(arrType[i].isNillable());
            }
            if (this.intVersion >= 2) {
                this.writeBoolean(arrType[i].getType().isIdentified());
                if (arrType[i].getDefaultValue() != null) {
                    this.writeByte(125);
                    this.writeObject(arrType[i].getDefaultValue(), this.arrTypes[i]);
                } else {
                    this.writeByte(124);
                }
            }
            if (this.intVersion < 3 || !FeatureStreamSupport.isGeometryType(this.arrTypes[i])) continue;
            GeometryDescriptor geomDescriptor = (GeometryDescriptor)arrType[i];
            CoordinateReferenceSystem crs = geomDescriptor.getCoordinateReferenceSystem();
            this.writeSRS(crs);
        }
        this.writeByte(127);
    }

    private void writeSRS(CoordinateReferenceSystem crs) throws IOException {
        if (this.intVersion < 3) {
            return;
        }
        String srs = crs != null ? CRS.toSRS((CoordinateReferenceSystem)crs) : "";
        this.writeUTF(srs);
    }

    public void writeFeature(SimpleFeature f) throws IOException {
        this.writeByte(125);
        int intAttCount = f.getAttributeCount();
        this.writeUTF(f.getID());
        for (int i = 0; i < intAttCount; ++i) {
            Object obj = f.getAttribute(i);
            if (obj == null) {
                this.writeByte(124);
                continue;
            }
            try {
                this.writeByte(125);
                this.writeObject(obj, this.arrTypes[i]);
                continue;
            }
            catch (IOException ioex) {
                throw new IOException(String.format("Error writing attribute '%s' of feature '%s': %s", obj, f, ioex.getMessage()), ioex);
            }
        }
    }

    private void writeObject(Object obj, byte bytType) throws IOException {
        switch (bytType) {
            case 0: {
                this.writeBoolean((Boolean)obj);
                break;
            }
            case 1: {
                this.writeByte(((Number)obj).byteValue());
                break;
            }
            case 2: {
                this.writeInt(((Number)obj).intValue());
                break;
            }
            case 3: 
            case 8: {
                this.writeLong(((Number)obj).longValue());
                break;
            }
            case 4: {
                this.writeShort(((Number)obj).shortValue());
                break;
            }
            case 5: {
                this.writeFloat(((Number)obj).floatValue());
                break;
            }
            case 6: {
                this.writeDouble(((Number)obj).doubleValue());
                break;
            }
            case 7: {
                if (this.intVersion >= 1) {
                    BigDecimal bdObj = (BigDecimal)obj;
                    int bdscale = bdObj.scale();
                    byte[] arrbd = bdObj.unscaledValue().toByteArray();
                    this.writeInt(bdscale);
                    this.writeInt(arrbd.length);
                    this.write(arrbd);
                    break;
                }
                this.writeDouble(((Number)obj).doubleValue());
                break;
            }
            case 10: {
                this.writeUTF((String)obj);
                break;
            }
            case 11: {
                this.writeLong(((Date)obj).getTime());
                break;
            }
            case 12: 
            case 13: {
                this.writeLong(((Date)obj).getTime());
                break;
            }
            case 14: {
                if (StringUtils.equals((CharSequence)obj.getClass().getCanonicalName(), (CharSequence)"oracle.sql.TIMESTAMP")) {
                    try {
                        Method m = obj.getClass().getMethod("timestampValue", new Class[0]);
                        obj = m.invoke(obj, new Object[0]);
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                }
                this.writeLong(((Date)obj).getTime());
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                Geometry geom = (Geometry)obj;
                byte[] arrbyte = geom.getUserData() instanceof byte[] ? (byte[])geom.getUserData() : this.wkbWriter.write(geom);
                this.writeInt(arrbyte.length);
                this.write(arrbyte);
                break;
            }
            default: {
                this.writeUTF(obj.toString());
            }
        }
    }

    public void markEnd() throws IOException {
        this.markEnd(null);
    }

    public void markEnd(String _errorMessage) throws IOException {
        if (StringUtils.isBlank((CharSequence)_errorMessage)) {
            this.writeByte(127);
        } else {
            this.writeByte(123);
            this.writeUTF(_errorMessage);
        }
        this.endMarkWritten = true;
    }

    @Override
    public void close() throws IOException {
        this.markEnd(null);
        super.close();
    }

    public void closeWithError(String errorMessage) throws IOException {
        this.markEnd(errorMessage);
        super.close();
    }

    protected void finalize() throws Throwable {
        if (!this.endMarkWritten) {
            LOG.warn("No END_BYTE or ERROR_BYTE written. Stream needs closing or explicit written END_BYTE/ERROR_BYTE.");
        }
        super.finalize();
    }
}

