/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.data.io;

import de.riwagis.geotools.data.io.FeatureStreamSupport;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureInputStream
extends DataInputStream {
    private static final Logger log = LoggerFactory.getLogger(FeatureInputStream.class);
    private final WKBReader wkbReader = new WKBReader();
    private SimpleFeatureType fType = null;
    private byte[] arrTypes = null;
    private boolean bolHasNext = true;
    private boolean bolReadHasNext = true;
    private final int intMaxVersion = 3;
    private final int intMinVersion = 0;
    private int intVersion = -1;

    public FeatureInputStream(InputStream _in) throws IOException {
        super(_in);
        this.readHeader();
    }

    private void readHeader() throws IOException {
        if (!this.isBeginByte(this.readByte())) {
            return;
        }
        this.intVersion = this.readInt();
        if (this.intVersion > 3) {
            throw new IOException("Version of feature data stream is not supported. Please update FeatureInputStream.class.");
        }
        if (this.intVersion < 0) {
            throw new IOException("Version of feature data stream is not supported. Please update FeatureOutputStream.class.");
        }
        String strFTypeName = this.readUTF();
        String strNamespaceURI = this.readUTF();
        CoordinateReferenceSystem crs = this.readCRS();
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(strFTypeName);
        ftBuilder.setNamespaceURI(strNamespaceURI);
        ftBuilder.setCRS(crs);
        this.arrTypes = new byte[this.readInt()];
        int counter = 0;
        AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
        while (this.isSeparatorByte(this.readByte())) {
            byte typeByte;
            String strAttName = this.readUTF();
            this.arrTypes[counter] = typeByte = this.readByte();
            boolean isNillable = this.readBoolean();
            attBuilder.setName(strAttName);
            Class<?> clsBinding = FeatureStreamSupport.getClassType(typeByte);
            attBuilder.setBinding(FeatureStreamSupport.getClassType(typeByte));
            attBuilder.setNillable(isNillable);
            if (this.intVersion >= 2) {
                attBuilder.setIdentifiable(this.readBoolean());
                byte defaultValueType = this.readByte();
                if (defaultValueType == 125) {
                    Object defaultValue = this.readObject(typeByte);
                    attBuilder.setDefaultValue(defaultValue);
                }
            }
            if (Geometry.class.isAssignableFrom(clsBinding)) {
                attBuilder.setCRS(this.readCRS());
                ftBuilder.add((AttributeDescriptor)attBuilder.buildDescriptor(strAttName, attBuilder.buildGeometryType()));
            } else {
                ftBuilder.add(attBuilder.buildDescriptor(strAttName, attBuilder.buildType()));
            }
            ++counter;
        }
        try {
            this.fType = ftBuilder.buildFeatureType();
        }
        catch (Exception e) {
            throw new IOException("Schema exception at FeatureTypeBuilder");
        }
    }

    private CoordinateReferenceSystem readCRS() throws IOException {
        if (this.intVersion < 3) {
            return null;
        }
        try {
            String srs = this.readUTF();
            if (StringUtils.isNotBlank((CharSequence)srs)) {
                return CRS.decode((String)srs);
            }
            return null;
        }
        catch (FactoryException ex) {
            throw new IllegalStateException("Could not set CRS from feature stream", ex);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.fType;
    }

    private boolean isBeginByte(byte byte2check) throws IOException {
        return byte2check == 126;
    }

    private boolean isNullByte(byte byte2check) throws IOException {
        return byte2check == 124;
    }

    private boolean isEndByte(byte byte2check) throws IOException {
        return byte2check == 127;
    }

    private boolean isErrorByte(byte byte2check) throws IOException {
        return byte2check == 123;
    }

    private boolean isSeparatorByte(byte byte2check) throws IOException {
        return byte2check == 125;
    }

    public boolean hasNextFeature() throws IOException {
        block7: {
            if (!this.bolReadHasNext) {
                return this.bolHasNext;
            }
            try {
                byte nextByte = this.readByte();
                this.bolHasNext = this.isSeparatorByte(nextByte);
                if (this.bolHasNext) break block7;
                if (this.isErrorByte(nextByte)) {
                    String errorMessage = "";
                    try {
                        errorMessage = this.readUTF();
                    }
                    catch (Throwable t) {
                        throw new IOException("Unknown error in feature data stream.");
                    }
                    throw new IOException(errorMessage);
                }
                if (!this.isEndByte(nextByte)) {
                    throw new IOException("No next feature and no end byte. Maybe an error occured at writing features. Please check log files.");
                }
            }
            catch (EOFException eofex) {
                throw new EOFException(String.format("EOF before end byte. Maybe an error occured at FeatureOutputStream. (original message: '%s')", eofex.getMessage()));
            }
        }
        this.bolReadHasNext = false;
        return this.bolHasNext;
    }

    public void skipFeature() throws IOException {
        if (this.bolReadHasNext) {
            this.hasNextFeature();
        }
        if (!this.bolHasNext) {
            throw new IOException("No feature in stream.");
        }
        this.bolReadHasNext = true;
        this.readUTF();
        try {
            for (int i = 0; i < this.fType.getAttributeCount(); ++i) {
                if (this.isNullByte(this.readByte())) continue;
                this.readObject(this.arrTypes[i]);
            }
        }
        catch (Exception e) {
            throw new IOException("Error skipping feature. " + e.getMessage());
        }
    }

    public SimpleFeature readFeature() throws IOException {
        if (this.bolReadHasNext) {
            this.hasNextFeature();
        }
        if (!this.bolHasNext) {
            throw new IOException("No feature in stream.");
        }
        this.bolReadHasNext = true;
        Object[] arrObj = new Object[this.fType.getAttributeCount()];
        String strID = this.readUTF();
        try {
            for (int i = 0; i < arrObj.length; ++i) {
                arrObj[i] = this.isNullByte(this.readByte()) ? null : this.readObject(this.arrTypes[i]);
            }
        }
        catch (IOException eofex) {
            throw eofex;
        }
        catch (Exception e) {
            throw new IOException("Error reading feature id=" + strID + ". " + e.getMessage());
        }
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)this.fType, (Object[])arrObj, (String)strID);
        }
        catch (Exception e) {
            throw new IOException("Error creating feature from object array. " + e.getMessage());
        }
    }

    private Object readObject(byte bytType) throws IOException {
        try {
            switch (bytType) {
                case 0: {
                    return this.readBoolean();
                }
                case 1: {
                    return this.readByte();
                }
                case 2: {
                    return this.readInt();
                }
                case 3: {
                    return this.readLong();
                }
                case 8: {
                    return this.readLong();
                }
                case 4: {
                    return this.readShort();
                }
                case 5: {
                    return Float.valueOf(this.readFloat());
                }
                case 6: {
                    return this.readDouble();
                }
                case 7: {
                    if (this.intVersion >= 1) {
                        int intScale = this.readInt();
                        int length = this.readInt();
                        byte[] arrbyte = new byte[length];
                        this.readFully(arrbyte);
                        return new BigDecimal(new BigInteger(arrbyte), intScale);
                    }
                    return BigDecimal.valueOf(this.readDouble());
                }
                case 10: {
                    return this.readUTF();
                }
                case 11: {
                    return new java.util.Date(this.readLong());
                }
                case 12: {
                    return new Date(this.readLong());
                }
                case 13: {
                    return new Time(this.readLong());
                }
                case 14: {
                    return new Timestamp(this.readLong());
                }
                case 20: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 21: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 22: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 23: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 24: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 25: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 26: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
                case 27: {
                    int length = this.readInt();
                    byte[] arrbyte = new byte[length];
                    this.readFully(arrbyte);
                    return this.wkbReader.read(arrbyte);
                }
            }
            return this.readUTF();
        }
        catch (ParseException e) {
            throw new IOException("Error parsing geometry InputStream." + e.getMessage());
        }
    }
}

