/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.crs;

import de.riwagis.crs.CRSDefFactory;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class Transformer {
    private final CoordinateReferenceSystem sourceCRS;
    private final CoordinateReferenceSystem targetCRS;
    private final CoordinateOperation coordOp;
    private final MathTransform transform;
    private final MathTransform invtransform;
    private final CoordinateOperationFactory coFactory = Transformer.getCoordinateOperationFactory();

    public Transformer(String sourceCRS, String targetCRS) throws OperationNotFoundException, FactoryException, NoninvertibleTransformException {
        this(CRSDefFactory.createCRS(sourceCRS), CRSDefFactory.createCRS(targetCRS));
    }

    public Transformer(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException, NoninvertibleTransformException {
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.checkCRS(sourceCRS);
        this.checkCRS(targetCRS);
        if (sourceCRS != null && targetCRS != null) {
            this.coordOp = this.coFactory.createOperation(sourceCRS, targetCRS);
            this.transform = this.coordOp.getMathTransform();
            this.invtransform = this.transform.inverse();
        } else {
            this.coordOp = null;
            this.transform = null;
            this.invtransform = null;
        }
    }

    private static synchronized CoordinateOperationFactory getCoordinateOperationFactory() {
        return ReferencingFactoryFinder.getCoordinateOperationFactory(null);
    }

    private void checkCRS(CoordinateReferenceSystem crs) {
        if (!this.validDimension(crs)) {
            throw new IllegalArgumentException("only 2-dimensional CRS are supported");
        }
        if (!this.validAxis(crs)) {
            throw new IllegalArgumentException("CRS has invalid axis");
        }
    }

    private boolean validAxis(CoordinateReferenceSystem crs) {
        return !(crs.getCoordinateSystem().getAxis(0).getDirection() != AxisDirection.EAST && crs.getCoordinateSystem().getAxis(0).getDirection() != AxisDirection.NORTH || crs.getCoordinateSystem().getAxis(1).getDirection() != AxisDirection.EAST && crs.getCoordinateSystem().getAxis(1).getDirection() != AxisDirection.NORTH);
    }

    private boolean validDimension(CoordinateReferenceSystem crs) {
        return crs.getCoordinateSystem().getDimension() == 2;
    }

    private DirectPosition getDirectPosition(Coordinate coord, CoordinateReferenceSystem crs) {
        if (crs.getCoordinateSystem().getAxis(0).getDirection() == AxisDirection.EAST) {
            return new GeneralDirectPosition(coord.x, coord.y);
        }
        return new GeneralDirectPosition(coord.y, coord.x);
    }

    private static void toCoordinate(DirectPosition point, Coordinate coord, CoordinateReferenceSystem crs) {
        if (crs.getCoordinateSystem().getAxis(0).getDirection() == AxisDirection.EAST) {
            coord.x = point.getCoordinate()[0];
            coord.y = point.getCoordinate()[1];
        } else {
            coord.x = point.getCoordinate()[1];
            coord.y = point.getCoordinate()[0];
        }
    }

    public Coordinate invtransform2d(DirectPosition point) throws Exception {
        return this.transform2d(this.invtransform, point);
    }

    private Coordinate transform2d(MathTransform tr, DirectPosition point) throws TransformException, MismatchedDimensionException {
        if (tr == null || point == null) {
            return null;
        }
        DirectPosition resPoint = tr.transform(point, point);
        Coordinate coord = new Coordinate();
        Transformer.toCoordinate(resPoint, coord, this.targetCRS);
        return coord;
    }

    public void invtransform2d(Coordinate coord) throws MismatchedDimensionException, TransformException {
        if (this.invtransform == null) {
            return;
        }
        DirectPosition point = this.getDirectPosition(coord, this.sourceCRS);
        point = this.invtransform.transform(point, point);
        Transformer.toCoordinate(point, coord, this.targetCRS);
    }

    public Coordinate transform2d(DirectPosition point) throws MismatchedDimensionException, TransformException {
        return this.transform2d(this.transform, point);
    }

    @Deprecated
    public void invtransform2d(Geometry geom) throws Exception {
        if (this.invtransform != null && geom != null) {
            for (Coordinate c : geom.getCoordinates()) {
                this.invtransform2d(c);
            }
            geom.geometryChanged();
        }
    }

    public Geometry invtransform2dGeometry(Geometry geom) throws Exception {
        if (this.invtransform == null || geom == null) {
            throw new IllegalArgumentException("Parameter must not be null!");
        }
        return JTS.transform((Geometry)geom, (MathTransform)this.invtransform);
    }

    public void invtransform2d(SimpleFeature feat) throws Exception {
        if (feat.getDefaultGeometry() == null) {
            return;
        }
        Geometry geom = this.invtransform2dGeometry((Geometry)feat.getDefaultGeometry());
        feat.setDefaultGeometry((Object)geom);
    }

    public void invtransform2d(Envelope env) throws MismatchedDimensionException, TransformException {
        Coordinate coord1 = new Coordinate(env.getMinX(), env.getMinY());
        Coordinate coord2 = new Coordinate(env.getMaxX(), env.getMaxY());
        Coordinate coord3 = new Coordinate(env.getMaxX(), env.getMinY());
        Coordinate coord4 = new Coordinate(env.getMinX(), env.getMaxY());
        this.invtransform2d(coord1);
        this.invtransform2d(coord2);
        this.invtransform2d(coord3);
        this.invtransform2d(coord4);
        env.init(coord1, coord2);
        env.expandToInclude(coord3);
        env.expandToInclude(coord4);
    }

    public void transform2d(Coordinate coord) throws Exception {
        if (this.transform == null) {
            return;
        }
        DirectPosition point = this.getDirectPosition(coord, this.sourceCRS);
        point = this.transform.transform(point, point);
        Transformer.toCoordinate(point, coord, this.targetCRS);
    }

    @Deprecated
    public void transform2d(Geometry geom) throws Exception {
        if (this.transform != null && geom != null) {
            for (Coordinate c : geom.getCoordinates()) {
                this.transform2d(c);
            }
            geom.geometryChanged();
        }
    }

    public Geometry transform2dGeometry(Geometry geom) throws Exception {
        if (this.transform == null || geom == null) {
            throw new IllegalArgumentException("Parameter must not be null!");
        }
        return JTS.transform((Geometry)geom, (MathTransform)this.transform);
    }

    public void transform2d(SimpleFeature feat) throws Exception {
        if (feat.getDefaultGeometry() == null) {
            return;
        }
        Geometry geom = this.transform2dGeometry((Geometry)feat.getDefaultGeometry());
        feat.setDefaultGeometry((Object)geom);
    }

    public void transform2d(Envelope env) throws Exception {
        Coordinate coord1 = new Coordinate(env.getMinX(), env.getMinY());
        Coordinate coord2 = new Coordinate(env.getMaxX(), env.getMaxY());
        Coordinate coord3 = new Coordinate(env.getMaxX(), env.getMinY());
        Coordinate coord4 = new Coordinate(env.getMinX(), env.getMaxY());
        this.transform2d(coord1);
        this.transform2d(coord2);
        this.transform2d(coord3);
        this.transform2d(coord4);
        env.init(coord1, coord2);
        env.expandToInclude(coord3);
        env.expandToInclude(coord4);
    }

    public String transform2WKT() {
        return this.transform.toWKT();
    }

    public String invTransform2WKT() {
        return this.invtransform.toWKT();
    }
}

