/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.crs;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;

public class SRIDEnvelopeFactory {
    private static Map<String, Envelope> envMap = null;

    public static Envelope getEnvelope(String srid) {
        SRIDEnvelopeFactory.fillEnvelopes();
        return envMap.get(srid);
    }

    private static synchronized void fillEnvelopes() {
        if (envMap == null) {
            ResourceBundle rb = ResourceBundle.getBundle(SRIDEnvelopeFactory.class.getPackage().getName() + ".sridenv");
            Enumeration<String> keys = rb.getKeys();
            envMap = new HashMap<String, Envelope>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = rb.getString(key);
                envMap.put(key, SRIDEnvelopeFactory.readEnveloeEnvelope(value));
            }
        }
    }

    private static final Envelope readEnveloeEnvelope(String envString) {
        if (StringUtils.isEmpty((CharSequence)envString)) {
            return null;
        }
        String[] arrBBOX = envString.split("\\|");
        double minX = Double.parseDouble(arrBBOX[0]);
        double minY = Double.parseDouble(arrBBOX[1]);
        double maxX = Double.parseDouble(arrBBOX[2]);
        double maxY = Double.parseDouble(arrBBOX[3]);
        Envelope env = new Envelope(minX, maxX, minY, maxY);
        return env;
    }
}

