/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.crs;

import de.riwagis.crs.CRSDefFactory;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.ProjectionFunction;
import de.riwagis.unit.DrawingUnit;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectableCRSDefinition
implements CRSDefinition {
    private static final Logger log = LoggerFactory.getLogger(ProjectableCRSDefinition.class);
    private static final Integer MID_EARTH_RADIUS_METER = 6381000;
    private final String strCode;
    private final String strName;
    private final String strKey;
    private final CoordinateReferenceSystem crs;
    private final Map<Integer, ProjectionFunction> formulas;

    public ProjectableCRSDefinition(String strCode, String strName, String strKey) throws FactoryException {
        this.strCode = strCode;
        this.strName = strName;
        this.strKey = strKey;
        this.crs = CRSDefFactory.createCRS(strCode);
        this.formulas = this.getFormulaForSelectedCRS(strKey);
        if (!"xy".equals(strKey)) {
            Objects.requireNonNull(this.crs);
        }
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    @Override
    public String getName() {
        return this.strName;
    }

    @Override
    public String getCode() {
        return this.strCode;
    }

    @Override
    public String getKey() {
        return this.strKey;
    }

    public String toString() {
        String code = CRSDefFactory.isCrsSelfDefined(this.strCode) ? CRS.toSRS((CoordinateReferenceSystem)this.crs) : this.strCode;
        Object displayText = StringUtils.isBlank((CharSequence)code) ? this.strName : code + " (" + this.strName + ")";
        return StringUtils.abbreviate((String)displayText, (int)60);
    }

    @Override
    public int compareTo(CRSDefinition o) {
        return Integer.compare(ProjectableCRSDefinition.getSRSCode(this), ProjectableCRSDefinition.getSRSCode(o));
    }

    @Override
    public double getRealWorldDistance(double distance, double height, Coordinate coord, DrawingUnit unit) {
        if (this.getFormulas() == null) {
            return distance;
        }
        double result = this.formulas.get(0).calculate(this.getMidEasting(this.crs, coord), this.getUnitValueInMeter(height, unit), this.getUnitValueInMeter(distance, unit), this.getScaleFactor(this.crs), MID_EARTH_RADIUS_METER.intValue());
        return result / unit.getUnitInMeter();
    }

    @Override
    public double getRealWorldDistance(Geometry geom, double height, DrawingUnit unit) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        return this.getRealWorldDistance(geom.getLength(), height, this.getCenterCoordinate(geom), unit);
    }

    @Override
    public double getProjectedDistance(double distance, double height, Coordinate coord, DrawingUnit unit) {
        if (this.getFormulas() == null) {
            return distance;
        }
        double result = this.formulas.get(1).calculate(this.getMidEasting(this.crs, coord), this.getUnitValueInMeter(height, unit), this.getUnitValueInMeter(distance, unit), this.getScaleFactor(this.crs), MID_EARTH_RADIUS_METER.intValue());
        return result / unit.getUnitInMeter();
    }

    private Map<Integer, ProjectionFunction> getFormulas() {
        return this.formulas;
    }

    @Override
    public double getProjectedDistance(Geometry geom, double height, DrawingUnit unit) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        return this.getProjectedDistance(geom.getLength(), height, this.getCenterCoordinate(geom), unit);
    }

    @Override
    public double getRealWorldArea(double area, double height, Coordinate coord, DrawingUnit unit) {
        if (this.getFormulas() == null) {
            return area;
        }
        double result = this.formulas.get(2).calculate(this.getMidEasting(this.crs, coord), this.getUnitValueInMeter(height, unit), this.getAreaInMeter(area, unit), this.getScaleFactor(this.crs), MID_EARTH_RADIUS_METER.intValue());
        return result / this.getValueToSquare(unit.getUnitInMeter());
    }

    @Override
    public double getRealWorldArea(Geometry geom, double height, DrawingUnit unit) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        return this.getRealWorldArea(geom.getArea(), height, this.getCenterCoordinate(geom), unit);
    }

    @Override
    public double getProjectedArea(double area, double height, Coordinate coord, DrawingUnit unit) {
        if (this.getFormulas() == null) {
            return area;
        }
        double result = this.formulas.get(3).calculate(this.getMidEasting(this.crs, coord), this.getUnitValueInMeter(height, unit), this.getAreaInMeter(area, unit), this.getScaleFactor(this.crs), MID_EARTH_RADIUS_METER.intValue());
        return result / this.getValueToSquare(unit.getUnitInMeter());
    }

    @Override
    public double getProjectedArea(Geometry geom, double height, DrawingUnit unit) {
        if (geom == null || geom.isEmpty()) {
            return 0.0;
        }
        return this.getProjectedArea(geom.getArea(), height, this.getCenterCoordinate(geom), unit);
    }

    private Map<Integer, ProjectionFunction> getFormulaForSelectedCRS(String crsKey) {
        return CRSDefFactory.getCRSReductionFunctions(crsKey);
    }

    private double getMidEasting(CoordinateReferenceSystem crs, Coordinate coord) {
        double falseEasting = CRS.getMapProjection((CoordinateReferenceSystem)crs).getParameterValues().parameter("false_easting").doubleValue();
        return coord.x - falseEasting;
    }

    private double getScaleFactor(CoordinateReferenceSystem crs) {
        return CRS.getMapProjection((CoordinateReferenceSystem)crs).getParameterValues().parameter("scale_factor").doubleValue();
    }

    private double getUnitValueInMeter(double value, DrawingUnit unit) {
        return value * unit.getUnitInMeter();
    }

    private double getAreaInMeter(double area, DrawingUnit unit) {
        return area * this.getValueToSquare(unit.getUnitInMeter());
    }

    private double getValueToSquare(double value) {
        return value * value;
    }

    private Coordinate getCenterCoordinate(Geometry geom) {
        Point p = geom.getCentroid();
        return new Coordinate(p.getX(), p.getY());
    }

    private static int getSRSCode(CRSDefinition crsDef) {
        try {
            return Integer.parseInt(CRS.toSRS((CoordinateReferenceSystem)crsDef.getCRS(), (boolean)true));
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }
}

