/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.crs;

import java.awt.RenderingHints;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;

public class CustomGridShiftLocator
extends AbstractFactory
implements GridShiftLocator {
    public CustomGridShiftLocator() {
        super(50);
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public URL locateGrid(String grid) {
        try {
            Object systemDefaultCRSDir = Hints.getSystemDefault((RenderingHints.Key)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
            String directory = Objects.toString(systemDefaultCRSDir, "");
            if (StringUtils.isBlank((CharSequence)directory)) {
                return null;
            }
            return new File(directory, grid).toURI().toURL();
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("should never reach here", mue);
        }
    }
}

