/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.crs;

import bsh.EvalError;
import bsh.Interpreter;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.crs.GridshiftCoordinateOperationFactoryUsingWKT;
import de.riwagis.crs.ProjectableCRSDefinition;
import de.riwagis.crs.ProjectionFunction;
import de.riwagis.util.Config;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.geotools.util.factory.FactoryFinder;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRSDefFactory {
    private static final String CRS_KEY_UTM_32N_ETRS89 = "25832";
    public static final int NOSRID = -1;
    private static final Logger LOG;
    private static final String CRS_DEFINITIONS;
    private static final String CRS_REDUCTION_DEFINITIONS;
    private static final CRSAuthorityFactory CRS_FACTORY;
    private static final CRSFactory wktFac;
    private static final Map<String, CRSDefinition> mapCRS;
    private static final Map<String, Map<Integer, ProjectionFunction>> mapCRSReduction;
    private static CRSDefinition defaultCRS;
    private static final AtomicBoolean isInitialized;
    private static final AtomicBoolean isCRSReductionInitialized;

    static void registerGeotoolsFactories() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        if (Hints.getSystemDefault((RenderingHints.Key)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY) == null) {
            Hints.putSystemDefault((RenderingHints.Key)Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, (Object)"gridsets");
        }
        ReferencingFactoryFinder.getCRSAuthorityFactories(null).stream().filter(CartesianAuthorityFactory.class::isInstance).forEach(ReferencingFactoryFinder::removeAuthorityFactory);
        ReferencingFactoryFinder.addAuthorityFactory((AuthorityFactory)new GridshiftCoordinateOperationFactoryUsingWKT());
        CRSDefFactory.buildCRSAuthorityFactory();
    }

    private static synchronized CRSAuthorityFactory buildCRSAuthorityFactory() {
        CRSAuthorityFactory crsAuthorityFactory;
        try {
            crsAuthorityFactory = CRS.getAuthorityFactory((boolean)false);
        }
        catch (FactoryNotFoundException e) {
            LOG.warn("Error initializing CRSFactory. Deleting geotools directory in TEMP directory.", (Throwable)e);
            String strTempDir = System.getProperty("java.io.tmpdir");
            File crsDir = new File(strTempDir, "Geotools");
            if (crsDir.exists()) {
                FileUtils.deleteQuietly((File)crsDir);
            }
            crsAuthorityFactory = CRS.getAuthorityFactory((boolean)false);
        }
        return crsAuthorityFactory;
    }

    public static CRSAuthorityFactory getCRSAuthorityFactory() {
        return CRS_FACTORY;
    }

    public static CRSFactory getCRSFactory() {
        return wktFac;
    }

    private CRSDefFactory() {
    }

    private static synchronized void fillCRS() {
        if (isInitialized.compareAndSet(false, true)) {
            mapCRS.clear();
            ResourceBundle rb = ResourceBundle.getBundle(CRS_DEFINITIONS, Config.LOCALE);
            LOG.info("Initializing CRS from file '{}' (bundle: '{}')", (Object)CRS_DEFINITIONS, (Object)rb.getLocale());
            Enumeration<String> keyEnum = rb.getKeys();
            while (keyEnum.hasMoreElements()) {
                String strKey = keyEnum.nextElement();
                String strDef = rb.getString(strKey);
                CRSDefFactory.addCRS(strKey, strDef);
            }
            File sridFile = new File(new File("srid"), "crs.properties");
            if (sridFile.exists()) {
                CRSDefFactory.readCRSPropertyFile(mapCRS, sridFile, CRSDefFactory::addCRS, "CRS-Mappings");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean addCRS(String strKey, String strDefinition) {
        try {
            String[] arrTemp = strDefinition.split("\\|");
            String[] arrValues = new String[2];
            boolean xySystem = strDefinition.startsWith("_");
            if (arrTemp.length != 2) {
                if (!xySystem) throw new IllegalStateException("CRS Definitions has to contain exactly two parameters");
                arrValues[0] = arrTemp[0].substring(1);
            } else {
                System.arraycopy(arrTemp, 0, arrValues, 0, arrValues.length);
            }
            CRSDefinition crsDef = CRSDefFactory.createCRSDefinition(arrValues[0], arrValues[1], strKey);
            if (CRS_KEY_UTM_32N_ETRS89.equals(strKey) || defaultCRS != null && xySystem) {
                defaultCRS = crsDef;
            }
            mapCRS.put(strKey, crsDef);
            return true;
        }
        catch (FactoryException ex) {
            LOG.error("Could not add CRS", (Throwable)ex);
            return false;
        }
    }

    public static List<CRSDefinition> getCRSDefinitionList() {
        CRSDefFactory.fillCRS();
        return Collections.unmodifiableList(new ArrayList<CRSDefinition>(mapCRS.values()));
    }

    public static List<String> getKeyList() {
        CRSDefFactory.fillCRS();
        ArrayList<String> keys = new ArrayList<String>(mapCRS.keySet());
        Collections.sort(keys);
        return Collections.unmodifiableList(keys);
    }

    public static CRSDefinition getCRSDefinition(String strKey, Supplier<CRSDefinition> defaultValueSupplier) {
        CRSDefFactory.fillCRS();
        if (!mapCRS.containsKey(strKey)) {
            if (!StringUtils.equals((CharSequence)strKey, (CharSequence)"-1")) {
                LOG.warn("Coordinate System Definition not found for key '{}'. Default Coordinate System returned instead.", (Object)strKey);
            }
            return defaultValueSupplier.get();
        }
        return mapCRS.get(strKey);
    }

    public static CRSDefinition getCRSDefinition(String strKey) {
        return CRSDefFactory.getCRSDefinition(strKey, CRSDefFactory::getDefaultCRSDefinition);
    }

    public static boolean containsCRSDefinition(String strKey) {
        CRSDefFactory.fillCRS();
        return mapCRS.containsKey(strKey);
    }

    public static CRSDefinition getDefaultCRSDefinition() {
        CRSDefFactory.fillCRS();
        return defaultCRS;
    }

    public static String getKey(CRSDefinition crsDef) {
        return crsDef.getKey();
    }

    private static CRSDefinition createCRSDefinition(String strName, String strCode, String strKey) throws FactoryException {
        return new ProjectableCRSDefinition(strCode, strName, strKey);
    }

    public static synchronized CoordinateReferenceSystem createCRS(String code) throws FactoryException {
        CoordinateReferenceSystem res = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            if (CRSDefFactory.isCrsSelfDefined(code)) {
                String strWKT = code.substring(4);
                res = wktFac.createFromWKT(strWKT);
            } else {
                CRSDefFactory.fillCRS();
                if (mapCRS.containsKey(code)) {
                    return mapCRS.get(code).getCRS();
                }
                res = CRS_FACTORY.createCoordinateReferenceSystem(code);
            }
        }
        return res;
    }

    public static boolean isCrsSelfDefined(String code) {
        return StringUtils.startsWithIgnoreCase((CharSequence)code, (CharSequence)"wkt");
    }

    public static boolean isAxisInverted(CoordinateReferenceSystem crs) {
        CoordinateSystem cs = crs.getCoordinateSystem();
        String axisName = cs.getAxis(0).getAbbreviation().toUpperCase();
        return !"E".equals(axisName) && !"X".equals(axisName) && !"LAT".equals(axisName);
    }

    public static Map<Integer, ProjectionFunction> getCRSReductionFunctions(String crsKey) {
        if (mapCRSReduction.isEmpty()) {
            CRSDefFactory.fillCRSReduction();
        }
        return mapCRSReduction.get(crsKey);
    }

    private static synchronized void fillCRSReduction() {
        if (isCRSReductionInitialized.compareAndSet(false, true)) {
            mapCRSReduction.clear();
            ResourceBundle rb = ResourceBundle.getBundle(CRS_REDUCTION_DEFINITIONS);
            LOG.info("Initializing CRS Reduction from file '{}' (bundle: '{}')", (Object)CRS_REDUCTION_DEFINITIONS, (Object)rb.getLocale());
            Enumeration<String> keyEnum = rb.getKeys();
            while (keyEnum.hasMoreElements()) {
                String strKey = keyEnum.nextElement();
                String strFormulas = rb.getString(strKey);
                CRSDefFactory.addCRSFormulas(strKey, strFormulas);
            }
            File sridFile = new File(new File("srid"), "crs_reduction.properties");
            if (sridFile.exists()) {
                CRSDefFactory.readCRSPropertyFile(mapCRSReduction, sridFile, CRSDefFactory::addCRSFormulas, "CRS-Reduction Formulas");
            }
        }
    }

    private static boolean addCRSFormulas(String strKey, String strFormulas) {
        try {
            String[] arrTemp = strFormulas.split("\\|");
            String[] arrValues = new String[4];
            for (int i = 0; i < arrTemp.length; ++i) {
                arrValues[i] = arrTemp[i];
                if (i > 2) break;
            }
            HashMap<Integer, ProjectionFunction> map = new HashMap<Integer, ProjectionFunction>();
            for (int i = 0; i < arrValues.length; ++i) {
                map.put(i, CRSDefFactory.createFormulaType(arrValues[i]));
            }
            mapCRSReduction.put(strKey, map);
            return true;
        }
        catch (EvalError evalError) {
            LOG.error("Could not parse CRS-Reduction formula!", (Throwable)evalError);
            return false;
        }
    }

    private static ProjectionFunction createFormulaType(String formula) throws EvalError {
        Interpreter ip = new Interpreter();
        String codeInline = String.format("new de.riwagis.crs.ProjectionFunction() {public double calculate(double Em, double hm, double value, double SF, double RM) {return %s;}};", formula);
        return (ProjectionFunction)ip.eval(codeInline);
    }

    private static <T> void readCRSPropertyFile(Map<String, T> map, File sridFile, BiPredicate<String, String> consumer, String context) {
        LOG.info("Loading srid from file '{}' for {}", (Object)sridFile, (Object)context);
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(sridFile));
            Enumeration<Object> eKeyExt = prop.keys();
            while (eKeyExt.hasMoreElements()) {
                boolean successful;
                String strKey = eKeyExt.nextElement().toString();
                String strData = prop.getProperty(strKey);
                if (map.containsKey(strKey)) {
                    LOG.warn("CRS key {} already existed for {} and will be overwritten.", (Object)strKey, (Object)context);
                }
                if (successful = consumer.test(strKey, strData)) continue;
                LOG.error("Could not load srid '{}' for {}", (Object)strKey, (Object)context);
            }
        }
        catch (IOException ioe) {
            LOG.error("Error reading crs file from disk for " + context + ".", (Throwable)ioe);
        }
    }

    static {
        CRSDefFactory.registerGeotoolsFactories();
        LOG = LoggerFactory.getLogger(CRSDefFactory.class);
        CRS_DEFINITIONS = CRSDefFactory.class.getPackage().getName() + ".crs";
        CRS_REDUCTION_DEFINITIONS = CRSDefFactory.class.getPackage().getName() + ".crs_reduction";
        CRS_FACTORY = CRSDefFactory.buildCRSAuthorityFactory();
        wktFac = ReferencingFactoryFinder.getCRSFactory((Hints)FactoryFinder.EMPTY_HINTS);
        mapCRS = new LinkedHashMap<String, CRSDefinition>();
        mapCRSReduction = new HashMap<String, Map<Integer, ProjectionFunction>>();
        defaultCRS = null;
        isInitialized = new AtomicBoolean(false);
        isCRSReductionInitialized = new AtomicBoolean(false);
    }
}

