/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;

final class MonoOnAssembly<T>
extends MonoOperator<T, T>
implements Fuseable,
AssemblyOp {
    final FluxOnAssembly.AssemblySnapshotException stacktrace;

    MonoOnAssembly(Mono<? extends T> source) {
        super(source);
        this.stacktrace = new FluxOnAssembly.AssemblySnapshotException();
    }

    MonoOnAssembly(Mono<? extends T> source, @Nullable String description, boolean light) {
        super(source);
        this.stacktrace = light ? new FluxOnAssembly.AssemblyLightSnapshotException(description) : new FluxOnAssembly.AssemblySnapshotException(description);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new FluxOnAssembly.OnAssemblyConditionalSubscriber(cs, this.stacktrace, (Publisher<?>)this.source));
        } else {
            this.source.subscribe(new FluxOnAssembly.OnAssemblySubscriber<T>(actual, this.stacktrace, this.source));
        }
    }

    @Override
    public String toString() {
        return this.stacktrace.stackFirst();
    }
}

