/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoFromFluxOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class MonoCollectList<T, C extends Collection<? super T>>
extends MonoFromFluxOperator<T, C>
implements Fuseable {
    final Supplier<C> collectionSupplier;

    MonoCollectList(Flux<? extends T> source, Supplier<C> collectionSupplier) {
        super(source);
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public void subscribe(CoreSubscriber<? super C> actual) {
        Collection collection;
        try {
            collection = (Collection)Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable ex) {
            Operators.error(actual, Operators.onOperatorError(ex, actual.currentContext()));
            return;
        }
        this.source.subscribe(new MonoBufferAllSubscriber(actual, collection));
    }

    static final class MonoBufferAllSubscriber<T, C extends Collection<? super T>>
    extends Operators.MonoSubscriber<T, C> {
        C collection;
        Subscription s;

        MonoBufferAllSubscriber(CoreSubscriber<? super C> actual, C collection) {
            super(actual);
            this.collection = collection;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.collection == null;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.collection == null) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.collection.add(t);
        }

        @Override
        public void onError(Throwable t) {
            C c = this.collection;
            if (c == null) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.collection = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            C c = this.collection;
            if (c == null) {
                return;
            }
            this.collection = null;
            this.complete(c);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

