/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxDoOnEach<T>
extends FluxOperator<T, T> {
    final Consumer<? super Signal<T>> onSignal;

    FluxDoOnEach(Flux<? extends T> source, Consumer<? super Signal<T>> onSignal) {
        super(source);
        this.onSignal = Objects.requireNonNull(onSignal, "onSignal");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new DoOnEachSubscriber<T>(actual, this.onSignal, false));
    }

    static final class DoOnEachSubscriber<T>
    implements InnerOperator<T, T>,
    Signal<T> {
        private static final short STATE_FLUX_START = 0;
        private static final short STATE_MONO_START = 1;
        private static final short STATE_SKIP_HANDLER = 2;
        private static final short STATE_DONE = 3;
        final CoreSubscriber<? super T> actual;
        final Context cachedContext;
        final Consumer<? super Signal<T>> onSignal;
        T t;
        Subscription s;
        short state;

        DoOnEachSubscriber(CoreSubscriber<? super T> actual, Consumer<? super Signal<T>> onSignal, boolean monoFlavor) {
            this.actual = actual;
            this.cachedContext = actual.currentContext();
            this.onSignal = onSignal;
            this.state = monoFlavor ? (short)1 : 0;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.onSubscribe(this);
        }

        @Override
        public Context currentContext() {
            return this.cachedContext;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.state == 3;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public void onNext(T t) {
            if (this.state == 3) {
                Operators.onNextDropped(t, this.cachedContext);
                return;
            }
            try {
                this.t = t;
                this.onSignal.accept(this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.cachedContext));
                return;
            }
            if (this.state == 1) {
                this.state = (short)2;
                try {
                    this.onSignal.accept(Signal.complete(this.cachedContext));
                }
                catch (Throwable e) {
                    this.state = 1;
                    this.onError(Operators.onOperatorError(this.s, e, this.cachedContext));
                    return;
                }
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            block6: {
                if (this.state == 3) {
                    Operators.onErrorDropped(t, this.cachedContext);
                    return;
                }
                boolean applyHandler = this.state < 2;
                this.state = (short)3;
                if (applyHandler) {
                    try {
                        this.onSignal.accept(Signal.error(t, this.cachedContext));
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t, this.cachedContext);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t) break block6;
                    throw use;
                }
            }
        }

        public void onComplete() {
            if (this.state == 3) {
                return;
            }
            short oldState = this.state;
            this.state = (short)3;
            if (oldState < 2) {
                try {
                    this.onSignal.accept(Signal.complete(this.cachedContext));
                }
                catch (Throwable e) {
                    this.state = oldState;
                    this.onError(Operators.onOperatorError(this.s, e, this.cachedContext));
                    return;
                }
            }
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Throwable getThrowable() {
            return null;
        }

        @Override
        @Nullable
        public Subscription getSubscription() {
            return null;
        }

        @Override
        @Nullable
        public T get() {
            return this.t;
        }

        @Override
        public Context getContext() {
            return this.cachedContext;
        }

        @Override
        public SignalType getType() {
            return SignalType.ON_NEXT;
        }

        public String toString() {
            return "doOnEach_onNext(" + this.t + ")";
        }
    }
}

