/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.util;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.jai.util.Rational;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.media.jai.WritableRenderedImageAdapter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImageUtilities {
    public static final double[][] RGB_TO_GRAY_MATRIX;
    public static final double[][] RGBA_TO_GRAY_MATRIX;
    static final Logger LOGGER;
    private static final boolean mediaLibAvailable;
    public static final RenderingHints DONT_REPLACE_INDEX_COLOR_MODEL;
    public static final RenderingHints REPLACE_INDEX_COLOR_MODEL;
    public static final RenderingHints NN_INTERPOLATION_HINT;
    public static final RenderingHints NOCACHE_HINT;
    public static final RenderingHints EXTEND_BORDER_BY_COPYING;
    public static final RenderingHints EXTEND_BORDER_BY_REFLECT;
    private static final Dimension GEOTOOLS_DEFAULT_TILE_SIZE;
    private static final int GEOTOOLS_MIN_TILE_SIZE = 256;
    private static final int STRIPE_SIZE = 64;
    public static final String[] INTERPOLATION_NAMES;
    public static final int[] INTERPOLATION_TYPES;
    public static final BorderExtender DEFAULT_BORDER_EXTENDER;
    public static final RenderingHints BORDER_EXTENDER_HINTS;
    public static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    public static final float RATIONAL_TOLERANCE = 1.0E-6f;

    private ImageUtilities() {
    }

    public static ImageLayout getImageLayout(RenderedImage image) {
        return ImageUtilities.getImageLayout(image, true);
    }

    private static ImageLayout getImageLayout(RenderedImage image, boolean initToImage) {
        ImageLayout layout;
        if (image == null) {
            return null;
        }
        ImageLayout imageLayout = layout = initToImage ? new ImageLayout(image) : null;
        if (!(image.getNumXTiles() != 1 && image.getTileWidth() >= 64 || image.getNumYTiles() != 1 && image.getTileHeight() >= 64)) {
            boolean smallTileHeight;
            Dimension defaultSize;
            if (layout != null) {
                layout = layout.unsetTileLayout();
            }
            if ((defaultSize = JAI.getDefaultTileSize()) == null) {
                defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
            }
            int sw = ImageUtilities.toTileSize(image.getWidth(), defaultSize.width);
            int sh = ImageUtilities.toTileSize(image.getHeight(), defaultSize.height);
            boolean smallTileWidth = image.getTileWidth() <= 64;
            boolean bl = smallTileHeight = image.getTileHeight() < 64;
            if (sw != 0 || sh != 0 || smallTileHeight || smallTileWidth) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                if (sw != 0) {
                    layout = layout.setTileWidth(sw);
                    layout.setTileGridXOffset(image.getMinX());
                } else {
                    layout = smallTileWidth ? layout.setTileWidth(defaultSize.width) : layout.setTileWidth(image.getTileWidth());
                }
                if (sh != 0) {
                    layout = layout.setTileHeight(sh);
                    layout.setTileGridYOffset(image.getMinY());
                } else {
                    layout = smallTileHeight ? layout.setTileHeight(defaultSize.height) : layout.setTileHeight(image.getTileHeight());
                }
            }
        }
        return layout;
    }

    public static RenderingHints getRenderingHints(RenderedImage image) {
        ImageLayout layout = ImageUtilities.getImageLayout(image, false);
        return layout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout) : null;
    }

    public static Dimension toTileSize(Dimension size) {
        int s;
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
        }
        if ((s = ImageUtilities.toTileSize(size.width, defaultSize.width)) != 0) {
            size.width = s;
        }
        if ((s = ImageUtilities.toTileSize(size.height, defaultSize.height)) != 0) {
            size.height = s;
        }
        return size;
    }

    private static int toTileSize(int imageSize, int tileSize) {
        int MAX_TILE_SIZE = Math.min(tileSize * 2, imageSize);
        int stop = Math.max(tileSize - 256, MAX_TILE_SIZE - tileSize);
        int sopt = 0;
        int rmax = 0;
        for (int i = 0; i <= stop; ++i) {
            int r;
            int s = tileSize + i;
            if (s <= MAX_TILE_SIZE) {
                r = imageSize % s;
                if (r == 0) {
                    return s;
                }
                if (r > rmax) {
                    rmax = r;
                    sopt = s;
                }
            }
            if ((s = tileSize - i) < 256) continue;
            r = imageSize % s;
            if (r == 0) {
                return s;
            }
            if (r <= rmax) continue;
            rmax = r;
            sopt = s;
        }
        return rmax >= tileSize - tileSize / 4 ? sopt : 0;
    }

    public static ImageLayout createIntersection(ImageLayout layout, List<RenderedImage> sources) {
        int n;
        ImageLayout result = layout;
        if (result == null) {
            result = new ImageLayout();
        }
        if ((n = sources.size()) != 0) {
            RenderedImage source = sources.get(0);
            int minXL = result.getMinX(source);
            int minYL = result.getMinY(source);
            int maxXL = result.getWidth(source) + minXL;
            int maxYL = result.getHeight(source) + minYL;
            Iterator<RenderedImage> iterator = sources.iterator();
            while (iterator.hasNext()) {
                RenderedImage renderedImage;
                source = renderedImage = iterator.next();
                int minX = source.getMinX();
                int minY = source.getMinY();
                int maxX = source.getWidth() + minX;
                int maxY = source.getHeight() + minY;
                int mask = 0;
                if (minXL < minX) {
                    mask |= 5;
                }
                if (minYL < minY) {
                    mask |= 0xA;
                }
                if (maxXL > maxX) {
                    mask |= 4;
                }
                if (maxYL > maxY) {
                    mask |= 8;
                }
                if (mask == 0) continue;
                if (layout == result) {
                    result = (ImageLayout)layout.clone();
                }
                if ((mask & 1) != 0) {
                    minXL = minX;
                    result.setMinX(minXL);
                }
                if ((mask & 2) != 0) {
                    minYL = minY;
                    result.setMinY(minYL);
                }
                if ((mask & 4) != 0) {
                    maxXL = maxX;
                    result.setWidth(maxXL - minXL);
                }
                if ((mask & 8) == 0) continue;
                maxYL = maxY;
                result.setHeight(maxYL - minYL);
            }
            if (result != layout) {
                int newSize;
                int oldSize;
                source = sources.get(0);
                if (result.isValid(64) && (oldSize = result.getTileWidth(source)) != (newSize = ImageUtilities.toTileSize(result.getWidth(source), oldSize))) {
                    result.setTileWidth(newSize);
                }
                if (result.isValid(128) && (oldSize = result.getTileHeight(source)) != (newSize = ImageUtilities.toTileSize(result.getHeight(source), oldSize))) {
                    result.setTileHeight(newSize);
                }
            }
        }
        return result;
    }

    public static Interpolation toInterpolation(Object type) throws IllegalArgumentException {
        if (type instanceof Interpolation) {
            return (Interpolation)type;
        }
        if (type instanceof CharSequence) {
            String name = type.toString();
            int length = INTERPOLATION_NAMES.length;
            for (int i = 0; i < length; ++i) {
                if (!INTERPOLATION_NAMES[i].equalsIgnoreCase(name)) continue;
                return Interpolation.getInstance((int)INTERPOLATION_TYPES[i]);
            }
        }
        throw new IllegalArgumentException(Errors.format((int)183, (Object)type));
    }

    public static String getInterpolationName(Interpolation interp) {
        if (interp == null) {
            interp = Interpolation.getInstance((int)0);
        }
        String prefix = "Interpolation";
        for (Class<?> classe = interp.getClass(); classe != null; classe = classe.getSuperclass()) {
            String name = Classes.getShortName(classe);
            int index = name.lastIndexOf("Interpolation");
            if (index < 0) continue;
            return name.substring(index + "Interpolation".length());
        }
        return Classes.getShortClassName((Object)interp);
    }

    public static RenderedOp tileImage(RenderedOp image) throws IOException {
        ImageReader reader;
        int width = image.getWidth();
        int height = image.getHeight();
        int tileHeight = image.getTileHeight();
        int tileWidth = image.getTileWidth();
        boolean needToTile = false;
        Object o = image.getProperty("JAI.ImageReader");
        if (o instanceof ImageReader && !(reader = (ImageReader)o).isImageTiled(0)) {
            needToTile = true;
        }
        if (!needToTile && tileWidth == width && tileHeight <= height) {
            needToTile = true;
        }
        if (needToTile) {
            ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
            layout.unsetValid(768);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            return new ImageWorker((RenderedImage)image).setRenderingHints(hints).format(image.getSampleModel().getDataType()).getRenderedOperation();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(WritableRenderedImage image, Number value) {
        int y = image.getMinTileY();
        int ny = image.getNumYTiles();
        while (--ny >= 0) {
            int x = image.getMinTileX();
            int nx = image.getNumXTiles();
            while (--nx >= 0) {
                WritableRaster raster = image.getWritableTile(x, y);
                try {
                    ImageUtilities.fill(raster.getDataBuffer(), value);
                }
                finally {
                    image.releaseWritableTile(x, y);
                }
            }
        }
    }

    private static void fill(DataBuffer buffer, Number value) {
        int[] offsets = buffer.getOffsets();
        int size = buffer.getSize();
        if (buffer instanceof DataBufferByte) {
            DataBufferByte data = (DataBufferByte)buffer;
            byte n = value.byteValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else if (buffer instanceof DataBufferShort) {
            DataBufferShort data = (DataBufferShort)buffer;
            short n = value.shortValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else if (buffer instanceof DataBufferUShort) {
            DataBufferUShort data = (DataBufferUShort)buffer;
            short n = value.shortValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else if (buffer instanceof DataBufferInt) {
            DataBufferInt data = (DataBufferInt)buffer;
            int n = value.intValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else if (buffer instanceof DataBufferFloat) {
            DataBufferFloat data = (DataBufferFloat)buffer;
            float n = value.floatValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else if (buffer instanceof DataBufferDouble) {
            DataBufferDouble data = (DataBufferDouble)buffer;
            double n = value.doubleValue();
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
            }
        } else {
            throw new IllegalArgumentException(Errors.format((int)198));
        }
    }

    public static boolean isMediaLibAvailable() {
        return mediaLibAvailable;
    }

    public static void disposePlanarImageChain(PlanarImage pi) {
        Utilities.ensureNonNull((String)"PlanarImage", (Object)pi);
        ImageUtilities.disposePlanarImageChain(pi, new HashSet<PlanarImage>());
    }

    private static void disposePlanarImageChain(PlanarImage pi, Set<PlanarImage> visited) {
        Vector sinks = pi.getSinks();
        if (sinks != null) {
            for (Object sink : sinks) {
                if (sink instanceof PlanarImage && !visited.contains(sink)) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)sink, visited);
                    continue;
                }
                if (!(sink instanceof BufferedImage)) continue;
                ((BufferedImage)sink).flush();
            }
        }
        ImageUtilities.disposeSinglePlanarImage(pi);
        visited.add(pi);
        Vector sources = pi.getSources();
        if (sources != null) {
            for (Object child : sources) {
                if (child instanceof PlanarImage && !visited.contains(child)) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)child, visited);
                    continue;
                }
                if (!(child instanceof BufferedImage)) continue;
                ((BufferedImage)child).flush();
            }
        }
        if (pi instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)pi;
            for (Object param : op.getParameterBlock().getParameters()) {
                if (param instanceof ImageInputStream) {
                    ImageInputStream iis = (ImageInputStream)param;
                    try {
                        iis.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage());
                    }
                    continue;
                }
                if (!(param instanceof ImageReader)) continue;
                ImageReader reader = (ImageReader)param;
                reader.dispose();
            }
        }
    }

    public static RenderedImage maskColor(Color transparentColor, RenderedImage image) throws IllegalStateException {
        Utilities.ensureNonNull((String)"image", (Object)image);
        if (transparentColor == null) {
            return image;
        }
        ImageWorker w = new ImageWorker(image);
        if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            w.forceComponentColorModel();
        }
        return w.makeColorTransparent(transparentColor).getRenderedImage();
    }

    public static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        EnhancedImageReadParam newParam = new EnhancedImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        if (param instanceof EnhancedImageReadParam) {
            newParam.setBands(((EnhancedImageReadParam)param).getBands());
        }
        return newParam;
    }

    public static Rectangle2D layoutHelper(RenderedImage source, float scaleX, float scaleY, float transX, float transY, Interpolation interp) {
        Rational scaleXRational = Rational.approximate((float)scaleX, (float)1.0E-6f);
        Rational scaleYRational = Rational.approximate((float)scaleY, (float)1.0E-6f);
        long scaleXRationalNum = scaleXRational.num;
        long scaleXRationalDenom = scaleXRational.denom;
        long scaleYRationalNum = scaleYRational.num;
        long scaleYRationalDenom = scaleYRational.denom;
        Rational transXRational = Rational.approximate((float)transX, (float)1.0E-6f);
        Rational transYRational = Rational.approximate((float)transY, (float)1.0E-6f);
        long transXRationalNum = transXRational.num;
        long transXRationalDenom = transXRational.denom;
        long transYRationalNum = transYRational.num;
        long transYRationalDenom = transYRational.denom;
        int x0 = source.getMinX();
        int y0 = source.getMinY();
        int w = source.getWidth();
        int h = source.getHeight();
        long dx0Num = x0;
        long dx0Denom = 1L;
        long dy0Num = y0;
        long dy0Denom = 1L;
        long dx1Num = x0 + w;
        long dx1Denom = 1L;
        long dy1Num = y0 + h;
        long dy1Denom = 1L;
        dx0Num *= scaleXRationalNum;
        dx0Denom *= scaleXRationalDenom;
        dy0Num *= scaleYRationalNum;
        dy0Denom *= scaleYRationalDenom;
        dx1Num *= scaleXRationalNum;
        dx1Denom *= scaleXRationalDenom;
        dy1Num *= scaleYRationalNum;
        dy1Denom *= scaleYRationalDenom;
        dx0Num = 2L * dx0Num - dx0Denom;
        dx0Denom *= 2L;
        dy0Num = 2L * dy0Num - dy0Denom;
        dy0Denom *= 2L;
        dx1Num = 2L * dx1Num - 3L * dx1Denom;
        dx1Denom *= 2L;
        dy1Num = 2L * dy1Num - 3L * dy1Denom;
        dy1Denom *= 2L;
        dx0Num = dx0Num * transXRationalDenom + transXRationalNum * dx0Denom;
        dy0Num = dy0Num * transYRationalDenom + transYRationalNum * dy0Denom;
        dx1Num = dx1Num * transXRationalDenom + transXRationalNum * dx1Denom;
        dy1Num = dy1Num * transYRationalDenom + transYRationalNum * dy1Denom;
        int l_x0 = Rational.ceil((long)dx0Num, (long)(dx0Denom *= transXRationalDenom));
        int l_y0 = Rational.ceil((long)dy0Num, (long)(dy0Denom *= transYRationalDenom));
        int l_x1 = Rational.ceil((long)dx1Num, (long)(dx1Denom *= transXRationalDenom));
        int l_y1 = Rational.ceil((long)dy1Num, (long)(dy1Denom *= transYRationalDenom));
        Rectangle2D.Double retValue = new Rectangle2D.Double();
        retValue.setFrame(l_x0, l_y0, l_x1 - l_x0 + 1, l_y1 - l_y0 + 1);
        return retValue;
    }

    public static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        Utilities.ensureNonNull((String)"GeographicBoundingBox", (Object)geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public static ReferencedEnvelope getWGS84ReferencedEnvelope(GeneralEnvelope coverageEnvelope) {
        Utilities.ensureNonNull((String)"coverageEnvelope", (Object)coverageEnvelope);
        ReferencedEnvelope refEnv = new ReferencedEnvelope((Envelope)coverageEnvelope);
        try {
            return refEnv.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Rectangle getDimension(int imageIndex, ImageInputStream inStream, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        inStream.reset();
        reader.setInput(inStream);
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static final boolean checkEmptySourceRegion(ImageReadParam readParameters, Rectangle dimensions) {
        Utilities.ensureNonNull((String)"readDimension", (Object)dimensions);
        Utilities.ensureNonNull((String)"readP", (Object)readParameters);
        Rectangle sourceRegion = readParameters.getSourceRegion();
        Rectangle.intersect(sourceRegion, dimensions, sourceRegion);
        if (sourceRegion.isEmpty()) {
            return true;
        }
        readParameters.setSourceRegion(sourceRegion);
        return false;
    }

    public static Number[] getBackgroundValues(SampleModel sampleModel, double[] backgroundValues) {
        Number[] values = null;
        int dataType = sampleModel != null ? sampleModel.getDataType() : 5;
        int numBands = sampleModel != null ? sampleModel.getNumBands() : 1;
        switch (dataType) {
            case 0: {
                values = new Byte[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Byte.valueOf((byte)backgroundValues[0]) : Byte.valueOf((byte)backgroundValues[i]);
                }
                break;
            }
            case 1: 
            case 2: {
                values = new Short[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Short.valueOf((short)backgroundValues[0]) : Short.valueOf((short)backgroundValues[i]);
                }
                break;
            }
            case 3: {
                values = new Integer[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Integer.valueOf((int)backgroundValues[0]) : Integer.valueOf((int)backgroundValues[i]);
                }
                break;
            }
            case 4: {
                values = new Float[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, Float.valueOf(0.0f));
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Float.valueOf((float)backgroundValues[0]) : Float.valueOf((float)backgroundValues[i]);
                }
                break;
            }
            case 5: {
                values = new Double[numBands];
                if (backgroundValues == null) {
                    Arrays.fill(values, (Object)0.0);
                    break;
                }
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= backgroundValues.length ? Double.valueOf(backgroundValues[0]) : Double.valueOf(backgroundValues[i]);
                }
                break;
            }
        }
        return values;
    }

    public static void disposeImage(RenderedImage inputImage) {
        if (inputImage != null) {
            if (inputImage instanceof PlanarImage) {
                PlanarImage planarImage = (PlanarImage)inputImage;
                int nSources = planarImage.getNumSources();
                if (nSources > 0) {
                    for (int k = 0; k < nSources; ++k) {
                        Object source = null;
                        try {
                            source = planarImage.getSourceObject(k);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (source == null) continue;
                        if (source instanceof PlanarImage) {
                            ImageUtilities.disposeImage((RenderedImage)((PlanarImage)source));
                            continue;
                        }
                        if (!(source instanceof BufferedImage)) continue;
                        ((BufferedImage)source).flush();
                        source = null;
                    }
                } else {
                    Object imageReader = null;
                    try {
                        imageReader = inputImage.getProperty("JAI.ImageReader");
                    }
                    catch (NullPointerException source) {
                        // empty catch block
                    }
                    if (imageReader != null && imageReader instanceof ImageReader) {
                        ImageReader reader = (ImageReader)imageReader;
                        ImageInputStream stream = (ImageInputStream)reader.getInput();
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            reader.dispose();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                ImageUtilities.disposeSinglePlanarImage(planarImage);
            } else if (inputImage instanceof BufferedImage) {
                ((BufferedImage)inputImage).flush();
                inputImage = null;
            }
        }
    }

    public static void disposeSinglePlanarImage(PlanarImage planarImage) {
        Object roi = null;
        try {
            roi = planarImage.getProperty("ROI");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (roi != null && (ROI.class.equals(roi.getClass()) || roi instanceof RenderedImage)) {
            if (roi instanceof ROI) {
                PlanarImage image;
                ROI roiImage = (ROI)roi;
                Rectangle bounds = roiImage.getBounds();
                if (!bounds.isEmpty() && (image = roiImage.getAsImage()) != null) {
                    image.dispose();
                }
            } else {
                ImageUtilities.disposeImage((RenderedImage)roi);
            }
        }
        try {
            if (planarImage instanceof WritableRenderedImageAdapter) {
                ImageUtilities.cleanField(planarImage, "theWritableImage");
                ImageUtilities.cleanField(planarImage, "theImage", true);
            } else if (planarImage instanceof RenderedImageAdapter) {
                ImageUtilities.cleanField(planarImage, "theImage");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.log(Level.FINE, "Failed to clear rendered image adapters field to null. Not a problem per se, but if the finalizer thread is not fast enough, this might result in a OOM", e);
        }
        planarImage.dispose();
    }

    private static void cleanField(Object theObject, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        ImageUtilities.cleanField(theObject, fieldName, false);
    }

    private static void cleanField(Object theObject, String fieldName, boolean superClass) throws NoSuchFieldException, IllegalAccessException {
        Class<?> theClass = theObject.getClass();
        if (superClass) {
            theClass = theClass.getSuperclass();
        }
        Field f = theClass.getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(theObject, null);
    }

    public static String getDatabufferTypeName(int dataType) {
        switch (dataType) {
            case 1: {
                return "TYPE_USHORT";
            }
            case 2: {
                return "TYPE_SHORT";
            }
            case 3: {
                return "TYPE_INT";
            }
            case 0: {
                return "TYPE_BYTE";
            }
            case 4: {
                return "TYPE_FLOAT";
            }
            case 5: {
                return "TYPE_DOUBLE";
            }
        }
        throw new UnsupportedOperationException("Wrong data type:" + dataType);
    }

    public static RenderedImage applyRescaling(Double[] scales, Double[] offsets, RenderedImage image, Hints hints) {
        if (scales == null && offsets == null) {
            return image;
        }
        int numBands = image.getSampleModel().getNumBands();
        double[] pscales = ImageUtilities.toPrimitiveArray(scales, numBands, 1.0);
        double[] poffsets = ImageUtilities.toPrimitiveArray(offsets, numBands, 0.0);
        boolean hasRescaling = false;
        for (int i = 0; i < numBands && !hasRescaling; ++i) {
            hasRescaling = poffsets[i] != 0.0 || pscales[i] != 1.0;
        }
        if (!hasRescaling) {
            return image;
        }
        Hints localHints = hints != null ? hints.clone() : (RenderingHints)JAI.getDefaultInstance().getRenderingHints().clone();
        ImageLayout layout = Optional.ofNullable((ImageLayout)localHints.get(JAI.KEY_IMAGE_LAYOUT)).map(il -> (ImageLayout)il.clone()).orElse((ImageLayout)new ImageLayout2(image));
        SampleModel sm = RasterFactory.createBandedSampleModel((int)5, (int)image.getTileWidth(), (int)image.getTileHeight(), (int)image.getSampleModel().getNumBands());
        layout.setSampleModel(sm);
        layout.setColorModel((ColorModel)new ComponentColorModel((ColorSpace)new BogusColorSpace(numBands), false, false, 1, 5));
        localHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        ImageWorker iw = new ImageWorker(image);
        iw.setRenderingHints((RenderingHints)localHints);
        iw.rescale(pscales, poffsets);
        return iw.getRenderedImage();
    }

    private static double[] toPrimitiveArray(Double[] input, int numBands, double defaultValue) {
        double[] result = new double[numBands];
        Arrays.fill(result, defaultValue);
        if (input != null) {
            int loopMax = Math.min(input.length, numBands);
            for (int i = 0; i < loopMax; ++i) {
                Double v = input[i];
                if (v == null) continue;
                result[i] = v;
            }
        }
        return result;
    }

    static {
        boolean mediaLib;
        RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        RGBA_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0, 0.0}};
        LOGGER = Logging.getLogger(ImageUtilities.class);
        Class<?> mediaLibImage = null;
        try {
            mediaLibImage = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
        DONT_REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
        NN_INTERPOLATION_HINT = new RenderingHints(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        NOCACHE_HINT = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        EXTEND_BORDER_BY_COPYING = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        EXTEND_BORDER_BY_REFLECT = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)2));
        GEOTOOLS_DEFAULT_TILE_SIZE = new Dimension(512, 512);
        INTERPOLATION_NAMES = new String[]{"Nearest", "NearestNeighbor", "Bilinear", "Bicubic", "Bicubic2"};
        INTERPOLATION_TYPES = new int[]{0, 0, 1, 2, 3};
        DEFAULT_BORDER_EXTENDER = BorderExtender.createInstance((int)1);
        BORDER_EXTENDER_HINTS = new RenderingHints(JAI.KEY_BORDER_EXTENDER, DEFAULT_BORDER_EXTENDER);
    }
}

