/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.jasperreports.datasource;

import de.riwagis.jasperreports.datasource.MultiplyingJRDataSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SampleMultiplyingJRDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SampleMultiplyingJRDataSourceFactory.class);
    private static final Map<String, Object> complexDSData = new LinkedHashMap<String, Object>();

    public static final List<Map<String, Object>> buildDSSourceMap(String fieldName, String[] content, String description) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        for (String currContent : content) {
            LinkedHashMap<String, Object> currMap = new LinkedHashMap<String, Object>();
            SampleMultiplyingJRDataSourceFactory.addDSSourceMap(currMap, fieldName, currContent, description);
            res.add(currMap);
        }
        return res;
    }

    public static final void addDSSourceMap(Map<String, Object> dest, String fieldName, String content, String description) {
        dest.put(fieldName, new String[]{content, description});
    }

    public static final MultiplyingJRDataSource createComplexDataSource() {
        try {
            return new MultiplyingJRDataSource(complexDSData);
        }
        catch (JRException ex) {
            LOG.info("error creating SampleMultiplyingJRDataSource", (Throwable)ex);
            return null;
        }
    }

    public static final MultiplyingJRDataSource createSimpleDataSource() {
        try {
            LinkedHashMap<String, Object> simpleData = new LinkedHashMap<String, Object>();
            simpleData.put("str1", new String[]{"Hallo", "String1"});
            simpleData.put("str2", new String[]{null, "String2"});
            simpleData.put("str3", new String[]{"Hallo3", "String3"});
            return new MultiplyingJRDataSource(simpleData);
        }
        catch (JRException ex) {
            LOG.info("error creating SampleMultiplyingJRDataSource", (Throwable)ex);
            return null;
        }
    }

    static {
        complexDSData.put("str1", new String[]{"Hallo", "Hallo Text 1"});
        Object[][] daten = new Object[][]{{"GRAY", "Hinz", Double.toString(20000.0), new String[][]{{"Hund", "Frolic", "Bello"}}}, {"GREEN", "Kunz", Double.toString(30000.0), new String[][]{{"Katze", "Brekkies", "Mikesch"}, {"Maus", "N\u00fcsse", "Mickey"}}}, {"BLUE", "Maier", Double.toString(50000.0), new String[0][]}, {"RED", "Leidermann", Double.toString(210000.0), new String[][]{{"Delpin", "Barsch", "Flipper"}, {"Schabe", "Brotkrumen", "Cuccaracha"}}}};
        ArrayList<LinkedHashMap<String, Object>> liste1 = new ArrayList<LinkedHashMap<String, Object>>();
        complexDSData.put("liste1", liste1);
        for (Object[] datensatz : daten) {
            LinkedHashMap<String, Object> person = new LinkedHashMap<String, Object>();
            SampleMultiplyingJRDataSourceFactory.addDSSourceMap(person, "farbe", ObjectUtils.toString((Object)datensatz[0]), "Lieblingsfarbe");
            SampleMultiplyingJRDataSourceFactory.addDSSourceMap(person, "name", ObjectUtils.toString((Object)datensatz[1]), "Name der Person");
            SampleMultiplyingJRDataSourceFactory.addDSSourceMap(person, "gehalt", ObjectUtils.toString((Object)datensatz[2]), "Gehalt");
            ArrayList<LinkedHashMap<String, Object>> haustier = new ArrayList<LinkedHashMap<String, Object>>();
            person.put("haustier", haustier);
            for (String[] currHaustier : (String[][])datensatz[3]) {
                LinkedHashMap<String, Object> currHaustierMap = new LinkedHashMap<String, Object>();
                SampleMultiplyingJRDataSourceFactory.addDSSourceMap(currHaustierMap, "tierart", currHaustier[0], "Tierart");
                SampleMultiplyingJRDataSourceFactory.addDSSourceMap(currHaustierMap, "futter", currHaustier[1], "Futter");
                SampleMultiplyingJRDataSourceFactory.addDSSourceMap(currHaustierMap, "name", currHaustier[2], "Name des Haustiers");
                haustier.add(currHaustierMap);
            }
            liste1.add(person);
        }
        complexDSData.put("str2", new String[]{"HalliHallo", "Hallo Text 2"});
    }
}

