/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.jasperreports.datasource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplyingJRDataSource
implements JRRewindableDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplyingJRDataSource.class);
    private final Map<String, Object> mapData;
    private final List<List<Map<String, Object>>> lists = new ArrayList<List<Map<String, Object>>>();
    private final Map<List<Map<String, Object>>, Integer> listIndices = new LinkedHashMap<List<Map<String, Object>>, Integer>();
    protected final Map<String, Object> currentLine = new LinkedHashMap<String, Object>();
    private int lineCount;
    private boolean hasMoreEntries;

    public MultiplyingJRDataSource(Map<String, Object> mapData) throws JRException {
        this.mapData = mapData;
        MultiplyingJRDataSource.determineLists(this.lists, mapData);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Lists: %d", this.lists.size()));
        }
        this.moveFirst();
    }

    public static final void determineLists(List<List<Map<String, Object>>> knownLists, Map<String, Object> mapData) {
        for (Map.Entry<String, Object> strKey : mapData.entrySet()) {
            Object objValue = strKey.getValue();
            if (!(objValue instanceof List)) continue;
            List currList = (List)objValue;
            knownLists.add(currList);
            for (Map currSubData : currList) {
                MultiplyingJRDataSource.determineLists(knownLists, currSubData);
            }
        }
    }

    public boolean next() throws JRException {
        boolean hme = this.hasMoreEntries;
        boolean bl = this.hasMoreEntries = this.hasMoreEntries && !this.lists.isEmpty();
        if (this.hasMoreEntries) {
            this.fillCurrentLine();
            ++this.lineCount;
            this.hasMoreEntries = MultiplyingJRDataSource.increaseListcount(this.lists, this.listIndices, this.mapData);
        }
        return hme;
    }

    private static String currStateString(List<List<Map<String, Object>>> dataLists, Map<List<Map<String, Object>>, Integer> listIndices) {
        ArrayList<String> currIndexString = new ArrayList<String>();
        for (int i = 0; i < dataLists.size(); ++i) {
            List<Map<String, Object>> currList = dataLists.get(i);
            Integer x = listIndices.get(currList);
            if (x == null) continue;
            currIndexString.add(String.format("[%d: %d (%d/%d)]", i, x, x + 1, currList.size()));
        }
        return StringUtils.join(currIndexString, (String)", ");
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Queried: %s", jrf.getName()));
        }
        if (this.currentLine.containsKey(jrf.getName())) {
            return this.currentLine.get(jrf.getName());
        }
        return null;
    }

    public final void moveFirst() throws JRException {
        MultiplyingJRDataSource.reinitIndices(this.lists, this.listIndices);
        this.hasMoreEntries = !this.mapData.isEmpty();
        this.lineCount = 0;
        this.fillCurrentLine();
    }

    public static final void reinitIndices(List<List<Map<String, Object>>> dataLists, Map<List<Map<String, Object>>, Integer> listIndices) {
        listIndices.clear();
        for (List<Map<String, Object>> currList : dataLists) {
            listIndices.put(currList, 0);
        }
    }

    public static final boolean increaseListcount(List<List<Map<String, Object>>> _lists, Map<List<Map<String, Object>>, Integer> indices, Map<String, Object> mapData) {
        boolean increased = false;
        for (Object currEntry : mapData.values()) {
            Map subData;
            if (increased || !(currEntry instanceof List)) continue;
            List currList = (List)currEntry;
            int currIdx = indices.get(currList);
            if ((currIdx <= currList.size() || currList.isEmpty() && currIdx == 0) && !currList.isEmpty() && !(increased = MultiplyingJRDataSource.increaseListcount(_lists, indices, subData = (Map)currList.get(currIdx)))) {
                boolean bl = increased = ++currIdx < currList.size() || currList.isEmpty() && currIdx == 1;
            }
            if (!increased) continue;
            indices.put(currList, currIdx);
        }
        return increased;
    }

    public static void fillCurrentLineFromMap(String prefix, Map<String, Object> subset, Map<String, Object> currentLine, Map<List<Map<String, Object>>, Integer> listIndices) {
        for (Map.Entry<String, Object> key : subset.entrySet()) {
            Object objValue = key.getValue();
            String prefixedKey = prefix + key.getKey();
            if (objValue instanceof String) {
                currentLine.put(prefixedKey, (String)objValue);
            }
            if (objValue instanceof String[]) {
                currentLine.put(prefixedKey, ((String[])objValue)[0]);
            }
            if (!(objValue instanceof List)) continue;
            List currSubList = (List)objValue;
            int idx = listIndices.get(currSubList);
            if (currSubList.size() <= 0 || !listIndices.containsKey(currSubList)) continue;
            Map currSubsetMap = (Map)currSubList.get(idx);
            MultiplyingJRDataSource.fillCurrentLineFromMap(prefixedKey + ".", currSubsetMap, currentLine, listIndices);
        }
    }

    private void fillCurrentLine() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Line %d: next-->%s (Indices: %s)", this.lineCount, this.hasMoreEntries, MultiplyingJRDataSource.currStateString(this.lists, this.listIndices)));
        }
        this.currentLine.clear();
        MultiplyingJRDataSource.fillCurrentLineFromMap("", this.mapData, this.currentLine, this.listIndices);
    }
}

