/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.rtf.RTFTemplate;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.document.transformer.config.DigesterTransformerConfig;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import net.sourceforge.rtf.helper.RTFTemplateBuilder;
import net.sourceforge.rtf.template.IContext;
import net.sourceforge.rtf.web.RTFTemplateException;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRTFTemplateServlet
extends HttpServlet {
    public static final String RTF_CONTENT_TYPE = "application/rtf";
    private Map cachedTransformedDocumentMap = new HashMap();
    private ApplicationContext globalApplicationContext;

    public void init() {
        this.globalApplicationContext = this.getGlobalApplicationContext();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ApplicationContext applicationContext = this.getApplicationContext(request);
            if (applicationContext == null) {
                applicationContext = this.globalApplicationContext;
            }
            String cacheWitkKey = this.cacheWithKey(request);
            String unCackeWitkKey = this.unCacheWithKey(request);
            if (unCackeWitkKey != null) {
                this.cachedTransformedDocumentMap.remove(unCackeWitkKey);
            }
            RTFTemplateBuilder builder = null;
            builder = applicationContext == null ? RTFTemplateBuilder.newRTFTemplateBuilder() : RTFTemplateBuilder.newRTFTemplateBuilder(applicationContext);
            String rtfTemplateImpl = this.getRTFTemplateImpl(request);
            RTFTemplate rtfTemplate = rtfTemplateImpl != null ? builder.newRTFTemplate(rtfTemplateImpl) : builder.newRTFTemplate();
            rtfTemplate.setGroupByPerPageBreak(this.getGroupByPerPageBreak(request));
            this.putDefaultFormat(request, rtfTemplate);
            IContext ctx = rtfTemplate.getTemplateEngine().newContext();
            this.putGlobalContext(request, ctx);
            boolean isAlreadyCached = this.setTemplate(request, rtfTemplate, cacheWitkKey);
            this.putContext(request, rtfTemplate.getContext());
            this.setContentType(request, response);
            String fileName = this.getFileNameOfContentDisposition(request);
            if (fileName != null) {
                this.setContentDisposition(response, fileName);
            }
            PrintWriter writer = response.getWriter();
            rtfTemplate.merge(writer);
            if (cacheWitkKey != null && !isAlreadyCached) {
                this.cachedTransformedDocumentMap.put(cacheWitkKey, rtfTemplate.getTransformedDocument());
            }
        }
        catch (Exception e) {
            this.error(request, response, e);
        }
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception cause) throws ServletException, IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<title>Error</title>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>RTFTemplateServlet: Error processing RTF edition</h2>");
        html.append("<pre>");
        String why = cause.getMessage();
        if (why != null && why.trim().length() > 0) {
            html.append(why);
            html.append("<br>");
        }
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</pre>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(RTF_CONTENT_TYPE);
    }

    protected void setContentDisposition(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    protected Reader getRTFReader(HttpServletRequest request) throws Exception {
        return null;
    }

    protected InputStream getRTFInputStream(HttpServletRequest request) throws Exception {
        return null;
    }

    protected abstract void putContext(HttpServletRequest var1, IContext var2) throws Exception;

    protected abstract InputStream getXMLFieldsAvailable(HttpServletRequest var1) throws Exception;

    protected InputStream getTransformerConfig(HttpServletRequest request) {
        return null;
    }

    protected String getRealPathOfRTFModel(HttpServletRequest request, String rtfModelFile) {
        return request.getRealPath("") + rtfModelFile;
    }

    protected String getFileNameOfContentDisposition(HttpServletRequest request) {
        return null;
    }

    protected String getRTFTemplateImpl(HttpServletRequest request) {
        return null;
    }

    protected void putDefaultFormat(HttpServletRequest request, RTFTemplate rtfTemplate) {
    }

    protected void putGlobalContext(HttpServletRequest request, IContext newContext) {
    }

    protected int getGroupByPerPageBreak(HttpServletRequest request) {
        return -1;
    }

    protected String cacheWithKey(HttpServletRequest request) {
        return null;
    }

    protected String unCacheWithKey(HttpServletRequest request) {
        return null;
    }

    protected ApplicationContext getGlobalApplicationContext() {
        return null;
    }

    protected ApplicationContext getApplicationContext(HttpServletRequest request) {
        return null;
    }

    private boolean setTemplate(HttpServletRequest request, RTFTemplate rtfTemplate, String cackeWitkKey) throws Exception {
        RTFDocument cachedTransformedDocument;
        if (cackeWitkKey != null && (cachedTransformedDocument = (RTFDocument)this.cachedTransformedDocumentMap.get(cackeWitkKey)) != null) {
            rtfTemplate.setTransformedDocument(cachedTransformedDocument);
            return true;
        }
        InputStream rtfInputStream = null;
        Reader rtfReader = this.getRTFReader(request);
        if (rtfReader == null && (rtfInputStream = this.getRTFInputStream(request)) == null) {
            throw new RTFTemplateException("Impossible to launch RTF edition. Method RTFTemplateServlet.getRTFReader or RTFTemplateServlet.getRTFInputStream must not return null.");
        }
        if (rtfReader != null) {
            rtfTemplate.setTemplate(rtfReader);
        } else {
            rtfTemplate.setTemplate(rtfInputStream);
        }
        InputStream xmlFieldsStream = this.getXMLFieldsAvailable(request);
        rtfTemplate.setXmlFields(xmlFieldsStream);
        InputStream transformerConfigStream = this.getTransformerConfig(request);
        if (transformerConfigStream != null) {
            TransformerConfig transformConfig = DigesterTransformerConfig.getTransformerConfig(transformerConfigStream);
            rtfTemplate.setTransformerConfig(transformConfig);
        }
        return false;
    }
}

