/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.usecases;

import java.io.File;
import java.io.FileReader;
import net.sourceforge.rtf.ITemplateEngine;
import net.sourceforge.rtf.helper.RTFTemplateBuilder;
import net.sourceforge.rtf.template.IContext;

public abstract class AbstractTemplateEngineUseCase {
    private String rtfTemplateConfig;
    private String templateEngineType;
    private String outDirectory = null;

    public AbstractTemplateEngineUseCase() {
        this.templateEngineType = "vm";
    }

    public AbstractTemplateEngineUseCase(String outDirectory) {
        this.outDirectory = outDirectory;
    }

    public void run(String modelSource) throws Exception {
        File modelSourceFile = new File(modelSource);
        String modelOutput = modelSource + "." + this.getTemplateEngineType() + ".out";
        if (this.outDirectory != null) {
            File out = new File(this.outDirectory);
            out.mkdirs();
            modelOutput = this.outDirectory + "/" + modelSourceFile.getName() + "." + this.getTemplateEngineType() + ".out.rtf";
        }
        RTFTemplateBuilder builder = null;
        builder = this.rtfTemplateConfig == null ? RTFTemplateBuilder.newRTFTemplateBuilder() : RTFTemplateBuilder.newRTFTemplateBuilder(this.rtfTemplateConfig);
        ITemplateEngine templateEngine = builder.newTemplateEngine(this.getTemplateEngineType());
        templateEngine.setTemplate(new FileReader(modelSourceFile));
        IContext context = templateEngine.initializeContext();
        this.putContext(context);
        templateEngine.merge(modelOutput);
    }

    public String getTemplateEngineType() {
        if (this.templateEngineType == null) {
            this.templateEngineType = "vm";
        }
        return this.templateEngineType;
    }

    public void setTemplateEngineType(String templateEngineType) {
        this.templateEngineType = templateEngineType;
    }

    protected abstract void putContext(IContext var1);

    protected String getRtfTemplateConfig() {
        return this.rtfTemplateConfig;
    }

    protected void setRtfTemplateConfig(String rtfTemplateConfig) {
        this.rtfTemplateConfig = rtfTemplateConfig;
    }
}

