/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.usecases;

import java.io.File;
import java.io.FileInputStream;
import net.sourceforge.rtf.RTFTemplate;
import net.sourceforge.rtf.context.RTFContextFieldsReader;
import net.sourceforge.rtf.context.RTFContextUtil;
import net.sourceforge.rtf.context.RTFXmlFieldsReader;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.document.transformer.config.DigesterTransformerConfig;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import net.sourceforge.rtf.helper.RTFTemplateBuilder;
import net.sourceforge.rtf.template.IContext;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRTFUseCase {
    private RTFTemplate rtfTemplate = null;
    private File transformerConfigFile = null;
    private ApplicationContext applicationContext;
    private String rtfTemplateImpl;
    private boolean saveTransformedDocument = false;
    private String outDirectory = null;
    private int groupByPerPageBreak = -1;
    private boolean circularReferences = false;

    public AbstractRTFUseCase(String outDirectory) {
        this.outDirectory = outDirectory;
    }

    public final void run(String rtfSource) throws Exception {
        File rtfSourceFile = new File(rtfSource);
        String rtfTransformedDocumentOutput = rtfSource + "." + this.getRtfTemplateImpl() + ".rtf";
        String rtfOutput = rtfSource + "." + this.getRtfTemplateImpl() + ".out.rtf";
        if (this.outDirectory != null) {
            File out = new File(this.outDirectory);
            out.mkdirs();
            rtfTransformedDocumentOutput = this.outDirectory + "/" + rtfSourceFile.getName() + "." + this.getRtfTemplateImpl() + ".rtf";
            rtfOutput = this.outDirectory + "/" + rtfSourceFile.getName() + "." + this.getRtfTemplateImpl() + ".out.rtf";
        }
        RTFTemplateBuilder builder = null;
        builder = this.applicationContext == null ? RTFTemplateBuilder.newRTFTemplateBuilder() : RTFTemplateBuilder.newRTFTemplateBuilder(this.applicationContext);
        this.rtfTemplate = builder.newRTFTemplate(this.rtfTemplateImpl);
        this.rtfTemplate.setGroupByPerPageBreak(this.groupByPerPageBreak);
        this.rtfTemplate.setCircularReferences(this.circularReferences);
        this.putDefaultFormat(this.rtfTemplate);
        IContext ctx = this.rtfTemplate.getTemplateEngine().newContext();
        this.putGlobalContext(ctx);
        this.rtfTemplate.setTemplate(rtfSourceFile);
        this.rtfTemplate.setGlobalContext(ctx);
        if (this.transformerConfigFile != null) {
            TransformerConfig transformConfig = DigesterTransformerConfig.getTransformerConfig(new FileInputStream(this.transformerConfigFile));
            this.rtfTemplate.setTransformerConfig(transformConfig);
        }
        this.putContext(this.rtfTemplate.getContext());
        if (this.saveTransformedDocument) {
            RTFDocument transformedDocument = this.rtfTemplate.transform();
            transformedDocument.save(new File(rtfTransformedDocumentOutput));
        }
        this.rtfTemplate.merge(rtfOutput);
    }

    public String getXMLFields() {
        RTFXmlFieldsReader reader = new RTFXmlFieldsReader();
        reader.readContext(this.rtfTemplate.getContext(), this.rtfTemplate.getTransformerConfig(), this.rtfTemplate.isCircularReferences());
        return reader.getXMLFields();
    }

    protected void putDefaultFormat(RTFTemplate template) {
    }

    protected void putGlobalContext(IContext context) {
    }

    public void saveXmlFields(String filename, boolean force) throws Exception {
        RTFContextFieldsReader reader = new RTFContextFieldsReader();
        reader.readContext(this.rtfTemplate.getContext(), this.rtfTemplate.getTransformerConfig(), this.rtfTemplate.isCircularReferences());
        RTFContextUtil.saveXmlFields(filename, reader.getContextFields(), force);
    }

    protected abstract void putContext(IContext var1);

    public void setTransformerConfigFile(String transformerConfig) {
        this.setTransformerConfigFile(new File(transformerConfig));
    }

    public void setTransformerConfigFile(File transformerConfigFile) {
        this.transformerConfigFile = transformerConfigFile;
    }

    public void saveTransformedDocument(boolean saveTransformedDocument) {
        this.saveTransformedDocument = saveTransformedDocument;
    }

    public String getRtfTemplateImpl() {
        if (this.rtfTemplateImpl == null) {
            this.rtfTemplateImpl = "vmRTFTemplate";
        }
        return this.rtfTemplateImpl;
    }

    public void setRtfTemplateImpl(String rtfTemplateImpl) {
        this.rtfTemplateImpl = rtfTemplateImpl;
    }

    protected int getGroupByPerPageBreak() {
        return this.groupByPerPageBreak;
    }

    protected void setGroupByPerPageBreak(int groupByPerPageBreak) {
        this.groupByPerPageBreak = groupByPerPageBreak;
    }

    protected RTFTemplate getRtfTemplate() {
        return this.rtfTemplate;
    }

    protected void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean isCircularReferences() {
        return this.circularReferences;
    }

    public void setCircularReferences(boolean circularReferences) {
        this.circularReferences = circularReferences;
    }
}

