/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.template.velocity;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import java.util.Properties;
import net.sourceforge.rtf.template.AbstractTemplateEngine;
import net.sourceforge.rtf.template.IContext;
import net.sourceforge.rtf.template.velocity.VelocityContextImpl;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngineImpl
extends AbstractTemplateEngine {
    private VelocityEngine velocityEngine;
    private boolean isVelocityEngineInitialized;

    @Override
    public IContext newContext() {
        return new VelocityContextImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeWithTemplateEngine(Writer writer) throws Exception {
        if (this.velocityEngine == null) {
            throw new IOException("Velocity engine must be defined. Use setVelocityEngine method to set it.");
        }
        this.initializeVelocityEngine();
        VelocityContextImpl context = (VelocityContextImpl)super.getContext();
        EventCartridge events = new EventCartridge();
        events.addEventHandler((EventHandler)new InsertionHandler());
        events.attachToContext((Context)context);
        Reader reader = this.template;
        try {
            this.velocityEngine.evaluate((Context)context, writer, "", reader);
        }
        finally {
            reader.close();
        }
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
        this.isVelocityEngineInitialized = false;
    }

    private void initializeVelocityEngine() throws Exception {
        Properties p = new Properties();
        if (!this.isVelocityEngineInitialized) {
            this.velocityEngine.init(p);
        }
        this.isVelocityEngineInitialized = true;
    }

    protected class RTFContext
    extends VelocityContext {
        public static final long serialVersionUID = 1L;

        public RTFContext() {
        }

        public RTFContext(Context innerContext) {
            super(innerContext);
        }

        public Object put(String key, Object value) {
            if (key == null) {
                return null;
            }
            return this.internalPut(key, value);
        }
    }

    protected class InsertionHandler
    implements ReferenceInsertionEventHandler {
        protected InsertionHandler() {
        }

        public Object referenceInsert(String reference, Object value) {
            if (value == null) {
                value = "";
            } else {
                boolean escaped = VelocityTemplateEngineImpl.this.mustBeEscaped(value);
                Format format = (Format)VelocityTemplateEngineImpl.this.formats.get(value.getClass());
                if (format != null && (value = format.format(value)) == null) {
                    value = "";
                }
                if (escaped) {
                    value = VelocityTemplateEngineImpl.this.escapeSpecialCharacters(value);
                }
            }
            return value;
        }
    }
}

