/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.template.freemarker;

import net.sourceforge.rtf.template.AbstractRTFDocumentTransformer;
import net.sourceforge.rtf.util.StringUtils;

public class RTFFreemarkerTransformerImpl
extends AbstractRTFDocumentTransformer {
    @Override
    protected String getMacroEndForEach() {
        return "</#list>";
    }

    @Override
    protected String getForeach(String fieldName, String fieldNameWithListInfo) {
        if (fieldName.startsWith("$")) {
            fieldName = fieldName.substring(1);
        }
        String objectName = this.getObjectValueListInsideForEach(fieldName, fieldNameWithListInfo, false);
        String objectNameList = this.getItemListName(fieldName, fieldNameWithListInfo);
        StringBuffer foreachFreemarker = new StringBuffer("");
        foreachFreemarker.append("<#list ");
        foreachFreemarker.append(objectNameList);
        foreachFreemarker.append(" as ");
        foreachFreemarker.append(objectName);
        foreachFreemarker.append("> ");
        return foreachFreemarker.toString();
    }

    @Override
    protected String getObjectValueList(String fieldName, boolean withGetter) {
        return this.getObjectValueList(fieldName, withGetter, true);
    }

    protected String getObjectValueList(String fieldName, boolean withGetter, boolean escape) {
        String objectName = "";
        String getterName = "";
        if (fieldName.startsWith("$")) {
            fieldName = fieldName.substring(1);
        }
        objectName = fieldName;
        int dotLastIndex = fieldName.lastIndexOf(".");
        if (dotLastIndex != -1) {
            objectName = fieldName.substring(0, dotLastIndex);
            objectName = objectName.replace('.', '_');
            getterName = fieldName.substring(dotLastIndex + 1, fieldName.length());
        }
        if (!withGetter || getterName.length() <= 0) {
            return "item_" + objectName;
        }
        objectName = "item_" + objectName + "." + this.formatSubFieldName(getterName);
        if (escape) {
            return "${" + objectName + "}";
        }
        return objectName;
    }

    @Override
    protected String getObjectValueList(String fieldName, String fieldNameWithListInfo, boolean withGetter) {
        return "${" + this.getObjectValueListInsideForEach(fieldName, fieldNameWithListInfo, withGetter) + "}";
    }

    protected String getObjectValueListInsideForEach(String fieldName, String fieldNameWithListInfo, boolean withGetter) {
        int indexLastEndedArray;
        String objectName = "";
        if (fieldNameWithListInfo != null && fieldNameWithListInfo.length() > 0 && (indexLastEndedArray = fieldNameWithListInfo.lastIndexOf("]")) > 0 && fieldNameWithListInfo.indexOf(".", indexLastEndedArray + 2) > 0) {
            String s = fieldNameWithListInfo.substring(0, indexLastEndedArray);
            s = s.replaceAll("\\[", "");
            objectName = this.getObjectValueList(s, true, false);
            objectName = objectName.replace('.', '_');
            if (!withGetter) {
                return objectName;
            }
            return objectName + this.formatFieldName(fieldNameWithListInfo.substring(indexLastEndedArray + 1, fieldNameWithListInfo.length()));
        }
        return this.getObjectValueList(fieldName, withGetter, false);
    }

    @Override
    protected String formatSubFieldName(String fieldName) {
        if (fieldName.length() > 0) {
            String characterFirst = fieldName.substring(0, 1);
            characterFirst = characterFirst.toLowerCase();
            fieldName = characterFirst + fieldName.substring(1, fieldName.length());
        }
        return fieldName;
    }

    @Override
    public String getTransformedFieldName(boolean fieldIsList, String fieldName) {
        if (fieldIsList) {
            return fieldName;
        }
        String newFieldName = this.formatFieldName(fieldName);
        return "${" + newFieldName + "}";
    }

    private String formatFieldName(String fieldName) {
        StringBuffer newFieldName = new StringBuffer();
        String[] splitFieldName = StringUtils.split(fieldName, ".");
        for (int i = 0; i < splitFieldName.length; ++i) {
            String subFieldName = splitFieldName[i];
            if (i > 0) {
                subFieldName = this.formatSubFieldName(subFieldName);
                newFieldName.append(".");
            }
            if (subFieldName.startsWith("$")) {
                subFieldName = subFieldName.substring(1, subFieldName.length());
            }
            newFieldName.append(subFieldName);
        }
        if (fieldName.startsWith(".")) {
            return "." + newFieldName.toString();
        }
        return newFieldName.toString();
    }

    @Override
    protected String getMacroPageBreak(String listName, String rtfPageBreakContent) {
        String itemNameList = this.getObjectValueList(listName, false, false);
        return "<#if " + itemNameList + "_index lt $" + listName + "?size) " + rtfPageBreakContent + "</#if>";
    }

    @Override
    protected String getMacroPageBreak(String listName, String rtfPageBreakContent, int groupByPerPageBreak) {
        String itemNameList = this.getObjectValueList(listName, false, false);
        return " <#if " + itemNameList + "_index lt " + listName + "?size && " + itemNameList + "_index%" + String.valueOf(groupByPerPageBreak + 1) + "==" + String.valueOf(groupByPerPageBreak - 1) + " > " + rtfPageBreakContent + "</#if> ";
    }

    @Override
    protected String getMacroIf(String condition) {
        return "<#if " + condition + " >";
    }

    @Override
    protected String getMacroEndIf() {
        return "</#if>";
    }

    @Override
    protected String getMacroElse() {
        return "<#else>";
    }
}

