/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.rtf.ITemplateEngine;
import net.sourceforge.rtf.format.DefaultInputStreamFormat;
import net.sourceforge.rtf.format.DefaultRTFCodeStringFormat;
import net.sourceforge.rtf.format.rtfcode.IRTFCode;
import net.sourceforge.rtf.format.rtfcode.RTFCodeString;
import net.sourceforge.rtf.template.IContext;

public abstract class AbstractTemplateEngine
implements ITemplateEngine {
    private IContext context;
    protected Map formats = new HashMap();
    protected Reader template;

    public AbstractTemplateEngine() {
        this.formats.put(FileInputStream.class, new DefaultInputStreamFormat());
        this.formats.put(InputStream.class, new DefaultInputStreamFormat());
        this.formats.put(RTFCodeString.class, new DefaultRTFCodeStringFormat());
    }

    @Override
    public void put(String key, Object value) {
        if (this.context == null) {
            this.context = this.newContext();
        }
        this.context.put(key, value);
    }

    @Override
    public void merge(String file) throws Exception {
        this.merge(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(File file) throws Exception {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            this.merge(writer);
        }
        finally {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
    }

    @Override
    public void merge(Writer writer) throws Exception {
        if (this.template == null) {
            throw new IOException("Template must be defined. Use setTemplate method to set it.");
        }
        this.mergeWithTemplateEngine(writer);
    }

    public void setFormatMap(Map commonFormats) {
        this.formats = commonFormats;
    }

    @Override
    public void setDefaultFormat(Class clazz, Format format) {
        this.formats.put(clazz, format);
    }

    public Format getDefaultFormat(Class clazz) {
        return (Format)this.formats.get(clazz);
    }

    protected void setContext(IContext context) {
        this.context = context;
    }

    @Override
    public IContext getContext() {
        if (this.context == null) {
            this.initializeContext();
        }
        return this.context;
    }

    @Override
    public void setTemplate(Reader template) {
        this.template = template;
    }

    public boolean mustBeEscaped(Object value) {
        if (value instanceof InputStream) {
            return false;
        }
        if (value != null && value instanceof IRTFCode) {
            return ((IRTFCode)value).isEscaped();
        }
        return true;
    }

    protected Object escapeSpecialCharacters(Object value) {
        if (value != null && value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.indexOf("{") != -1) {
                stringValue = stringValue.replaceAll("\\{", "\\\\{");
            }
            if (stringValue.indexOf("}") != -1) {
                stringValue = stringValue.replaceAll("\\}", "\\\\}");
            }
            return stringValue;
        }
        return value;
    }

    @Override
    public IContext initializeContext() {
        this.context = this.newContext();
        return this.context;
    }

    @Override
    public void setGlobalContext(IContext globalContext) {
        IContext newcontext = this.newContext(globalContext);
        if (this.context != null) {
            Object[] keys = this.context.getKeys();
            for (int kk = 0; kk < keys.length; ++kk) {
                newcontext.put((String)keys[kk], this.context.get((String)keys[kk]));
            }
        }
        this.context = newcontext;
    }

    private IContext newContext(IContext context) {
        IContext newcontext = this.newContext();
        if (context != null) {
            Object[] keys = context.getKeys();
            for (int kk = 0; kk < keys.length; ++kk) {
                newcontext.put((String)keys[kk], context.get((String)keys[kk]));
            }
        }
        return newcontext;
    }

    protected abstract void mergeWithTemplateEngine(Writer var1) throws Exception;
}

