/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.rtf.IRTFDocumentTransformer;
import net.sourceforge.rtf.context.RTFContextFieldsReader;
import net.sourceforge.rtf.context.fields.RTFContextField;
import net.sourceforge.rtf.context.fields.RTFContextFields;
import net.sourceforge.rtf.document.RTFAnnotation;
import net.sourceforge.rtf.document.RTFBookmark;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.document.RTFElement;
import net.sourceforge.rtf.document.RTFField;
import net.sourceforge.rtf.document.RTFPage;
import net.sourceforge.rtf.document.RTFRow;
import net.sourceforge.rtf.document.RTFStartBookmark;
import net.sourceforge.rtf.document.RTFUserProperty;
import net.sourceforge.rtf.document.transformer.config.DigesterTransformerConfig;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import net.sourceforge.rtf.document.transformer.fields.DefaultRTFHyperlinkTransform;
import net.sourceforge.rtf.document.transformer.fields.DefaultRTFMergeFieldTransform;
import net.sourceforge.rtf.document.transformer.fields.DefaultRTFSimpleTransform;
import net.sourceforge.rtf.document.transformer.fields.IRTFFieldNameTransform;
import net.sourceforge.rtf.document.transformer.fields.IRTFFieldTransform;
import net.sourceforge.rtf.template.IContext;
import net.sourceforge.rtf.util.StringUtils;

public abstract class AbstractRTFDocumentTransformer
implements IRTFDocumentTransformer,
IRTFFieldNameTransform {
    private static TransformerConfig defaultTransformerConfig;
    protected static final int RTF_ELEMENT_DOCUMENT = 0;
    protected static final int RTF_ELEMENT_STRINGBUFFER = 1;
    protected static final int RTF_ELEMENT_ROW = 2;
    protected static final int RTF_ELEMENT_FIELD = 3;
    protected static final int RTF_ELEMENT_BOOKMARK = 4;
    protected static final int RTF_ELEMENT_PAGE = 5;
    protected static final int RTF_ELEMENT_USERPROPERTY = 6;
    protected static final int RTF_ELEMENT_ANNOTATION = 7;
    private TransformerConfig transformerConfig;
    protected int groupByPerPageBreak = -1;
    protected List rowMustNotGenerateForeachList = null;
    protected Map bookmarkStartMap = new HashMap();
    protected Map bookmarkEndMap = new HashMap();
    protected Map bookmarkBkmEndMap = new HashMap();
    protected Map pageBeforeEndBookmarkMap = new HashMap();
    protected Map startBookmarksNotEnded = null;
    protected RTFBookmark lastEndLoopRTFBookmark = null;
    protected Vector startBookmarksList = new Vector();
    protected Map bookmarkIfMap = null;
    protected Map bookmarkEndIfMap = null;
    protected Map bookmarkElseMap = null;
    protected Map bookmarkBkmIfMap = null;
    protected Map rtfTransformMap = null;
    private boolean circularReferences;

    public AbstractRTFDocumentTransformer() {
        this.startBookmarksNotEnded = new HashMap();
        this.bookmarkIfMap = new HashMap();
        this.bookmarkEndIfMap = new HashMap();
        this.bookmarkElseMap = new HashMap();
        this.bookmarkBkmIfMap = new HashMap();
    }

    public TransformerConfig getTransformerConfig() {
        if (this.transformerConfig == null) {
            return defaultTransformerConfig;
        }
        return this.transformerConfig;
    }

    @Override
    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    @Override
    public RTFDocument transform(RTFDocument document, IContext context) throws IOException {
        RTFContextFields contextFields = context == null ? null : this.getContextFields(context, this.isCircularReferences());
        return this.transform(document, contextFields);
    }

    @Override
    public RTFDocument transform(RTFDocument document, RTFContextFields contextFields) throws IOException {
        RTFBookmark ifBookmark;
        String ifBookmarkName;
        int index;
        Map contextFieldsMap = contextFields == null ? new HashMap() : contextFields.getMergeFieldsMap();
        RTFDocument documentTransformed = new RTFDocument(document);
        this.transform(documentTransformed, documentTransformed.getElementList(), contextFieldsMap);
        for (String endBookmarkName : this.bookmarkEndMap.keySet()) {
            index = this.getTransformerConfig().getBookmarkIndex(endBookmarkName);
            String startBookmarkName = this.getTransformerConfig().getBookmarkStartLoopName(index);
            RTFBookmark startBookmark = (RTFBookmark)this.bookmarkStartMap.get(startBookmarkName);
            if (startBookmark == null) continue;
            RTFBookmark endBookmark = (RTFBookmark)this.bookmarkEndMap.get(endBookmarkName);
            String newContent = this.getMacroEndForEach();
            RTFPage page = (RTFPage)this.pageBeforeEndBookmarkMap.get(endBookmarkName);
            if (page != null) {
                String content = null;
                content = this.groupByPerPageBreak > -1 ? " " + this.getMacroPageBreak(startBookmark.getItemNameList(), page.getRTFFirstContentOfElement(), this.groupByPerPageBreak) + " " : " " + this.getMacroPageBreak(startBookmark.getItemNameList(), page.getRTFFirstContentOfElement()) + " ";
                page.replaceElement(content);
            } else if (this.groupByPerPageBreak > -1 && this.lastEndLoopRTFBookmark != null && this.lastEndLoopRTFBookmark.equals(endBookmark)) {
                newContent = this.getMacroPageBreak(startBookmark.getItemNameList(), "\\page", this.groupByPerPageBreak) + newContent;
            }
            endBookmark.replaceElement(newContent);
            RTFBookmark startBookmarkBKMEND = (RTFBookmark)this.bookmarkBkmEndMap.get(startBookmarkName);
            startBookmarkBKMEND.replaceElement("");
            RTFBookmark endBookmarkBKMEND = (RTFBookmark)this.bookmarkBkmEndMap.get(endBookmarkName);
            endBookmarkBKMEND.replaceElement("");
        }
        for (String endIfBookmarkName : this.bookmarkEndIfMap.keySet()) {
            index = this.getTransformerConfig().getBookmarkIndex(endIfBookmarkName);
            ifBookmarkName = this.getTransformerConfig().getBookmarkIfName(index);
            ifBookmark = (RTFBookmark)this.bookmarkIfMap.get(ifBookmarkName);
            if (ifBookmark == null) continue;
            RTFBookmark endIfBookmark = (RTFBookmark)this.bookmarkEndIfMap.get(endIfBookmarkName);
            endIfBookmark.replaceElement(this.getMacroEndIf());
            RTFBookmark endIfBookmarkBKMEND = (RTFBookmark)this.bookmarkBkmIfMap.get(endIfBookmarkName);
            endIfBookmarkBKMEND.replaceElement("");
        }
        for (String elseBookmarkName : this.bookmarkElseMap.keySet()) {
            index = this.getTransformerConfig().getBookmarkIndex(elseBookmarkName);
            ifBookmarkName = this.getTransformerConfig().getBookmarkIfName(index);
            ifBookmark = (RTFBookmark)this.bookmarkIfMap.get(ifBookmarkName);
            if (ifBookmark == null) continue;
            RTFBookmark elseBookmark = (RTFBookmark)this.bookmarkElseMap.get(elseBookmarkName);
            elseBookmark.replaceElement(this.getMacroElse());
        }
        return documentTransformed;
    }

    protected void transform(RTFElement parentElement, Vector elementList, Map contextFieldsMap) throws IOException {
        RTFPage lastPage = null;
        block12: for (Object element : elementList) {
            int elementType = this.getType(element);
            block0 : switch (elementType) {
                case 1: {
                    StringBuffer sringBuffer = (StringBuffer)element;
                    if (sringBuffer.length() != 2) break;
                    int index1 = sringBuffer.indexOf("\n");
                    int index2 = sringBuffer.indexOf("\r");
                    if (index1 == -1 || index2 == -1) continue block12;
                    sringBuffer.deleteCharAt(index1);
                    break;
                }
                case 4: {
                    RTFBookmark currentBookmark = (RTFBookmark)element;
                    String bookMarkName = currentBookmark.getName().toUpperCase();
                    if (this.isBookmarkStartLoop(bookMarkName)) {
                        if (currentBookmark instanceof RTFStartBookmark) {
                            this.startBookmarksList.addElement(currentBookmark);
                            lastPage = null;
                            break;
                        }
                        this.bookmarkBkmEndMap.put(bookMarkName, currentBookmark);
                        break;
                    }
                    if (this.isBookmarkEndLoop(bookMarkName)) {
                        if (currentBookmark instanceof RTFStartBookmark) {
                            this.bookmarkEndMap.put(bookMarkName, currentBookmark);
                            this.pageBeforeEndBookmarkMap.put(bookMarkName, lastPage);
                            this.lastEndLoopRTFBookmark = currentBookmark;
                        } else {
                            this.bookmarkBkmEndMap.put(bookMarkName, currentBookmark);
                        }
                        Collection bookmarksNotEnded = this.startBookmarksNotEnded.values();
                        for (RTFStartBookmark startBookmarkNoEnded : bookmarksNotEnded) {
                            String startBookmarkNameNoEnded = startBookmarkNoEnded.getName();
                            int index = this.getTransformerConfig().getBookmarkIndex(startBookmarkNameNoEnded);
                            String endBookmarkName = this.getTransformerConfig().getBookmarkEndLoopName(index);
                            if (!endBookmarkName.equals(currentBookmark.getName())) continue;
                            bookmarksNotEnded.remove(startBookmarkNoEnded);
                            break block0;
                        }
                        continue block12;
                    }
                    if (this.isBookmarkIf(bookMarkName)) {
                        if (currentBookmark instanceof RTFStartBookmark) {
                            this.bookmarkIfMap.put(bookMarkName, currentBookmark);
                            break;
                        }
                        this.bookmarkBkmIfMap.put(bookMarkName, currentBookmark);
                        break;
                    }
                    if (this.isBookmarkEndIf(bookMarkName)) {
                        if (currentBookmark instanceof RTFStartBookmark) {
                            this.bookmarkEndIfMap.put(bookMarkName, currentBookmark);
                            break;
                        }
                        this.bookmarkBkmIfMap.put(bookMarkName, currentBookmark);
                        break;
                    }
                    if (!this.isBookmarkElse(bookMarkName)) break;
                    if (currentBookmark instanceof RTFStartBookmark) {
                        this.bookmarkElseMap.put(bookMarkName, currentBookmark);
                        break;
                    }
                    this.bookmarkBkmIfMap.put(bookMarkName, currentBookmark);
                    break;
                }
                case 3: {
                    RTFBookmark ifBookmark;
                    String condition;
                    RTFField field = (RTFField)element;
                    String fieldName = field.getName();
                    if (fieldName == null) break;
                    int fieldType = field.getType();
                    RTFContextField rtfField = (RTFContextField)contextFieldsMap.get(fieldName);
                    if (rtfField != null) {
                        RTFRow row;
                        String newFieldName = "";
                        String fieldNameWithListInfo = rtfField.getListInfo();
                        boolean fieldIsList = this.isList(rtfField);
                        boolean fieldIsImage = this.isImage(rtfField);
                        switch (fieldType) {
                            case 2: {
                                IRTFFieldTransform hyperlinkTransform = this.getRTFFieldTransform(fieldName, fieldType, fieldIsImage);
                                hyperlinkTransform.transform(field, fieldIsList, this);
                                break;
                            }
                            case 1: {
                                IRTFFieldTransform fieldTransform = this.getRTFFieldTransform(fieldName, fieldType, fieldIsImage);
                                fieldTransform.transform(field, fieldIsList, this);
                            }
                        }
                        if (!fieldIsList) continue block12;
                        boolean loopIsManagedWithBookmark = false;
                        int bookmarkSize = this.startBookmarksList.size();
                        if (bookmarkSize > 0) {
                            RTFBookmark startBookmark = (RTFBookmark)this.startBookmarksList.elementAt(bookmarkSize - 1);
                            startBookmark.replaceElement(this.getForeach(fieldName, fieldNameWithListInfo));
                            startBookmark.setItemNameList(this.getItemListName(fieldName, fieldNameWithListInfo));
                            this.startBookmarksList.removeElement(startBookmark);
                            this.bookmarkStartMap.put(startBookmark.getName(), startBookmark);
                            this.startBookmarksNotEnded.put(startBookmark.getItemNameList(), startBookmark);
                            loopIsManagedWithBookmark = true;
                        } else {
                            String itemListName = this.getItemListName(fieldName, fieldNameWithListInfo);
                            boolean bl = loopIsManagedWithBookmark = this.startBookmarksNotEnded.get(itemListName) != null;
                        }
                        if (loopIsManagedWithBookmark) {
                            if (this.getType(parentElement) == 2) {
                                row = (RTFRow)parentElement;
                                if (this.rowMustNotGenerateForeachList == null) {
                                    this.rowMustNotGenerateForeachList = new ArrayList();
                                }
                                this.rowMustNotGenerateForeachList.add(row);
                            }
                        } else if (!(this.getType(parentElement) != 2 || (row = (RTFRow)parentElement).getFirstRTFString() != null || this.rowMustNotGenerateForeachList != null && this.rowMustNotGenerateForeachList.contains(row))) {
                            row.addFirstRTFString(this.getForeach(fieldName, fieldNameWithListInfo));
                            row.addLastRTFString(this.getMacroEndForEach());
                        }
                        String fieldContent = field.getRTFContentOfSimpleElement();
                        if (fieldName.startsWith("$")) {
                            fieldName = fieldName.substring(1);
                        }
                        if ((newFieldName = this.getObjectValueList(fieldName, fieldNameWithListInfo, true)).startsWith("$")) {
                            newFieldName = newFieldName.substring(1);
                        }
                        fieldContent = StringUtils.sub(fieldContent, fieldName, newFieldName);
                        field.replaceElement(fieldContent);
                        break;
                    }
                    if (fieldType != 4 || (condition = field.getCondition()) == null || (ifBookmark = (RTFBookmark)this.bookmarkIfMap.get(fieldName)) == null) continue block12;
                    condition = this.getMacroIf(condition);
                    ifBookmark.replaceElement(condition);
                    field.replaceElement("");
                    RTFBookmark ifBookmarkBKMEND = (RTFBookmark)this.bookmarkBkmIfMap.get(fieldName);
                    ifBookmarkBKMEND.replaceElement("");
                    break;
                }
                case 2: {
                    RTFRow row = (RTFRow)element;
                    this.transform(row, row.getElementList(), contextFieldsMap);
                    row.flush();
                    break;
                }
                case 5: {
                    lastPage = (RTFPage)element;
                    break;
                }
                case 6: {
                    RTFContextField rtfUserProperty;
                    boolean userPropertyIsList;
                    RTFUserProperty userProperty = (RTFUserProperty)element;
                    String userPropertyName = userProperty.getName();
                    if (userPropertyName != null && userPropertyName.startsWith("$") && (userPropertyIsList = this.isList(rtfUserProperty = (RTFContextField)contextFieldsMap.get(userPropertyName)))) {
                        String newUserPropertyValue;
                        String newUserpropertyName;
                        String userPropertyNameWithListInfo = rtfUserProperty.getListInfo();
                        String userPropertyContent = userProperty.getRTFContentOfSimpleElement();
                        if (userPropertyName.startsWith("$")) {
                            userPropertyName = userPropertyName.substring(1);
                        }
                        if ((newUserpropertyName = this.getObjectValueList(userPropertyName, userPropertyNameWithListInfo, true)).startsWith("$")) {
                            newUserpropertyName = newUserpropertyName.substring(1);
                        }
                        userPropertyContent = userPropertyContent.replaceAll(userPropertyName, newUserpropertyName);
                        userPropertyContent = this.getForeach(userPropertyName, userPropertyNameWithListInfo) + userPropertyContent + this.getMacroEndForEach();
                        String userPropertyValue = userProperty.getValue();
                        if (userPropertyValue.startsWith("$")) {
                            userPropertyValue = userPropertyValue.substring(1);
                        }
                        if ((newUserPropertyValue = this.getObjectValueList(userPropertyValue, userPropertyNameWithListInfo, true)).startsWith("$")) {
                            newUserPropertyValue = newUserPropertyValue.substring(1);
                        }
                        userPropertyContent = userPropertyContent.replaceAll(userPropertyValue, newUserPropertyValue);
                        userProperty.replaceElement(userPropertyContent);
                    }
                    String userPropertyContent = userProperty.getRTFContentOfSimpleElement();
                    userProperty.replaceElement(userPropertyContent);
                }
            }
        }
    }

    private int getType(Object element) throws IOException {
        if (element instanceof StringBuffer) {
            return 1;
        }
        if (element instanceof RTFRow) {
            return 2;
        }
        if (element instanceof RTFField) {
            return 3;
        }
        if (element instanceof RTFBookmark) {
            return 4;
        }
        if (element instanceof RTFDocument) {
            return 0;
        }
        if (element instanceof RTFPage) {
            return 5;
        }
        if (element instanceof RTFUserProperty) {
            return 6;
        }
        if (element instanceof RTFAnnotation) {
            return 7;
        }
        throw new IOException("Error getType into RTFVelocityTransformer : current element must be StringBuffer, RTFRow, RTFBookmark, RTFField, RTFPage or RTFUserProperty. ");
    }

    private boolean isList(RTFContextField rtfField) {
        if (rtfField != null) {
            return rtfField.isList();
        }
        return false;
    }

    private boolean isImage(RTFContextField rtfField) {
        if (rtfField != null) {
            return rtfField.isImage();
        }
        return false;
    }

    public boolean isBookmarkStartLoop(String bookmarkName) {
        return this.getTransformerConfig().isBookmarkStartLoop(bookmarkName);
    }

    public boolean isBookmarkEndLoop(String bookmarkName) {
        return this.getTransformerConfig().isBookmarkEndLoop(bookmarkName);
    }

    public boolean isBookmarkIf(String bookmarkName) {
        return this.getTransformerConfig().isBookmarkIf(bookmarkName);
    }

    public boolean isBookmarkEndIf(String bookmarkName) {
        return this.getTransformerConfig().isBookmarkEndIf(bookmarkName);
    }

    public boolean isBookmarkElse(String bookmarkName) {
        return this.getTransformerConfig().isBookmarkElse(bookmarkName);
    }

    private IRTFFieldTransform getRTFFieldTransform(String fieldName, int fieldType, boolean isFieldImage) {
        IRTFFieldTransform t = null;
        if (this.rtfTransformMap != null) {
            t = (IRTFFieldTransform)this.rtfTransformMap.get(fieldName);
        }
        if (t == null) {
            switch (fieldType) {
                case 1: {
                    if (isFieldImage) {
                        t = new DefaultRTFSimpleTransform();
                        break;
                    }
                    t = new DefaultRTFMergeFieldTransform();
                    break;
                }
                case 2: {
                    t = new DefaultRTFHyperlinkTransform();
                }
            }
        }
        return t;
    }

    public RTFContextFields getContextFields(IContext context, boolean hasCircularReferences) {
        RTFContextFieldsReader loader = new RTFContextFieldsReader();
        loader.readContext(context, hasCircularReferences);
        return loader.getContextFields();
    }

    @Override
    public void setGroupByPerPageBreak(int groupByPerPageBreak) {
        this.groupByPerPageBreak = groupByPerPageBreak;
    }

    protected String getItemListName(String fieldName, String fieldNameWithListInfo) {
        String[] splitFieldName;
        int characterSize;
        String objectName = fieldName;
        String objectNameList = fieldName;
        if (fieldNameWithListInfo != null && fieldNameWithListInfo.length() > 0) {
            int indexLastEndedArray;
            if (fieldNameWithListInfo.startsWith("$")) {
                fieldNameWithListInfo = fieldNameWithListInfo.substring(1);
            }
            if ((indexLastEndedArray = fieldNameWithListInfo.lastIndexOf("]")) > 0) {
                if (fieldNameWithListInfo.indexOf("]") != indexLastEndedArray) {
                    String s = fieldNameWithListInfo.substring(0, indexLastEndedArray + 1);
                    String[] splitUntilLastArray = StringUtils.split(s, ".");
                    if (splitUntilLastArray != null && splitUntilLastArray.length > 0) {
                        String currentObjectName = "";
                        String velocityNameList = "";
                        int nbList = 0;
                        boolean afterSecondList = false;
                        for (int i = splitUntilLastArray.length - 1; i >= 0; --i) {
                            currentObjectName = splitUntilLastArray[i];
                            if (currentObjectName.indexOf("[") != -1) {
                                currentObjectName = currentObjectName.replaceAll("\\[", "");
                                currentObjectName = currentObjectName.replaceAll("\\]", "");
                                ++nbList;
                            }
                            if (i == 0) {
                                currentObjectName = "item_" + currentObjectName;
                            }
                            velocityNameList = afterSecondList ? currentObjectName + "_" + velocityNameList : (velocityNameList.length() > 0 ? currentObjectName + "." + this.formatSubFieldName(velocityNameList) : currentObjectName);
                            if (nbList <= 1) continue;
                            afterSecondList = true;
                        }
                        return velocityNameList;
                    }
                } else {
                    String s = fieldNameWithListInfo.substring(0, indexLastEndedArray);
                    s = s.replaceAll("\\[", "");
                    return s;
                }
            }
        }
        if ((characterSize = (splitFieldName = StringUtils.split(fieldName, ".")).length - 1) > 0) {
            objectNameList = objectName = splitFieldName[characterSize - 1];
            if (characterSize > 1) {
                objectNameList = "item_" + splitFieldName[characterSize - 2] + "." + splitFieldName[characterSize - 1];
            }
        }
        return objectNameList;
    }

    protected abstract String getMacroEndForEach();

    protected abstract String getForeach(String var1, String var2);

    protected abstract String getObjectValueList(String var1, String var2, boolean var3);

    protected abstract String getObjectValueList(String var1, boolean var2);

    protected String formatSubFieldName(String fieldName) {
        return fieldName;
    }

    @Override
    public String getTransformedFieldName(boolean fieldIsList, String fieldName) {
        return fieldName;
    }

    protected abstract String getMacroPageBreak(String var1, String var2);

    protected abstract String getMacroPageBreak(String var1, String var2, int var3);

    protected abstract String getMacroIf(String var1);

    protected abstract String getMacroEndIf();

    protected abstract String getMacroElse();

    @Override
    public boolean isCircularReferences() {
        return this.circularReferences;
    }

    @Override
    public void setCircularReferences(boolean circularReferences) {
        this.circularReferences = circularReferences;
    }

    @Override
    public int getGroupByPerPageBreak() {
        return this.groupByPerPageBreak;
    }

    static {
        try {
            defaultTransformerConfig = DigesterTransformerConfig.getTransformerConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

