/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.parser;

import java.io.IOException;
import net.sourceforge.rtf.parser.AbstractCoreRTFParser;

public abstract class AbstractDefaultRTFParser
extends AbstractCoreRTFParser {
    private String starSlash = "";

    @Override
    protected void handleKeyword(String content) throws IOException {
        String keyword = content.trim();
        if (keyword.equals("\\trowd")) {
            this.startRow(content);
            return;
        }
        if (keyword.equals("\\row")) {
            this.endRow(content);
            return;
        }
        if (keyword.equals("\\intbl")) {
            this.inTable(content);
            return;
        }
        if (keyword.equals("\\field")) {
            this.startField(content);
            return;
        }
        if (keyword.equals("\\*")) {
            this.starSlash = content;
            return;
        }
        if (keyword.startsWith("\\bkmkstart")) {
            this.startBookmark(this.starSlash + content);
            this.starSlash = "";
            return;
        }
        if (keyword.startsWith("\\bkmkend")) {
            this.endBookmark(this.starSlash + content);
            this.starSlash = "";
            return;
        }
        if (keyword.equals("\\page")) {
            this.startPage(content);
            return;
        }
        if (keyword.startsWith("\\propname")) {
            this.startUserProperty(content);
            return;
        }
        if (keyword.startsWith("\\staticval")) {
            this.endUserProperty(content);
            return;
        }
        this.handleText(this.starSlash + content);
        this.starSlash = "";
    }

    protected abstract void startRow(String var1) throws IOException;

    protected abstract void endRow(String var1) throws IOException;

    protected abstract void inTable(String var1) throws IOException;

    protected abstract void startField(String var1) throws IOException;

    protected abstract void startBookmark(String var1) throws IOException;

    protected abstract void endBookmark(String var1) throws IOException;

    protected abstract void startPage(String var1) throws IOException;

    protected abstract void handleText(String var1) throws IOException;

    protected abstract void startUserProperty(String var1) throws IOException;

    protected abstract void endUserProperty(String var1) throws IOException;

    protected abstract void startAnnotation(String var1) throws IOException;
}

