/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class AbstractCoreRTFParser {
    private StringBuffer currentCharacters = new StringBuffer();
    private int level = 0;

    public void parse(Reader reader) throws IOException {
        int c;
        BufferedReader br = new BufferedReader(reader);
        while ((c = br.read()) != -1) {
            this.parse((char)c);
        }
        br.close();
    }

    public void parse(InputStream inputStream) throws IOException {
        int c;
        BufferedInputStream bs = new BufferedInputStream(inputStream);
        while ((c = bs.read()) != -1) {
            this.parse((char)c);
        }
        bs.close();
    }

    private void parse(char c) throws IOException {
        if (c == '{') {
            if (this.currentCharacters.length() > 0) {
                this.handleKeyword(this.currentCharacters.toString());
                this.currentCharacters = new StringBuffer();
            }
            ++this.level;
            this.startGroup(c, this.level);
            return;
        }
        if (c == '}') {
            if (this.currentCharacters.length() > 0) {
                this.handleKeyword(this.currentCharacters.toString());
                this.currentCharacters = new StringBuffer();
            }
            if (this.level == 0) {
                throw new IOException("Too many close-groups in RTF text");
            }
            this.endGroup(c, this.level);
            --this.level;
            return;
        }
        if (c == '\\') {
            if (this.currentCharacters.length() > 0) {
                this.handleKeyword(this.currentCharacters.toString());
                this.currentCharacters = new StringBuffer();
            }
            this.currentCharacters.append(c);
        } else {
            this.currentCharacters.append(c);
        }
    }

    protected int getLevel() {
        return this.level;
    }

    protected abstract void startGroup(char var1, int var2) throws IOException;

    protected abstract void endGroup(char var1, int var2) throws IOException;

    protected abstract void handleKeyword(String var1) throws IOException;
}

