/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.helper.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import net.sourceforge.rtf.IRTFDocumentParser;
import net.sourceforge.rtf.IRTFDocumentTransformer;
import net.sourceforge.rtf.context.fields.RTFContextField;
import net.sourceforge.rtf.context.fields.RTFContextFields;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.helper.RTFTemplateBuilder;
import net.sourceforge.rtf.helper.test.TestFreemarkerTransformer;

public class TestVelocityTransformer {
    public static void main(String[] args) {
        try {
            int c;
            RTFTemplateBuilder builder = RTFTemplateBuilder.newRTFTemplateBuilder();
            IRTFDocumentParser parser = builder.newRTFDocumentParser();
            String rtfSourceModel = "test.rtf";
            InputStream inputStream = TestFreemarkerTransformer.class.getResourceAsStream(rtfSourceModel);
            parser.parse(inputStream);
            RTFDocument document = parser.getRTFDocument();
            RTFContextFields context = new RTFContextFields();
            RTFContextField field = new RTFContextField();
            field.setName("$date");
            context.addMergeField(field);
            IRTFDocumentTransformer velocityTransformer = builder.newRTFDocumentTransformer("vmTransformer");
            RTFDocument transformedDocument = velocityTransformer.transform(document, context);
            Reader reader = transformedDocument.getReader();
            BufferedReader br = new BufferedReader(reader);
            while ((c = br.read()) != -1) {
                System.out.print((char)c);
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("Error");
            e.printStackTrace();
        }
    }
}

