/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.helper;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.rtf.IRTFDocumentParser;
import net.sourceforge.rtf.IRTFDocumentTransformer;
import net.sourceforge.rtf.ITemplateEngine;
import net.sourceforge.rtf.RTFTemplate;
import net.sourceforge.rtf.UnsupportedRTFDocumentParser;
import net.sourceforge.rtf.UnsupportedRTFDocumentTransformer;
import net.sourceforge.rtf.UnsupportedRTFTemplate;
import net.sourceforge.rtf.UnsupportedTemplateEngine;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class RTFTemplateBuilder {
    public static final String DEFAULT_FREEMARKER_RTFTEMPLATE = "ftlRTFTemplate";
    public static final String DEFAULT_VELOCITY_RTFTEMPLATE = "vmRTFTemplate";
    public static final String DEFAULT_RTFDOCUMENTPARSER = "defaultRTFParser";
    public static final String VELOCITY_ENGINE = "vm";
    public static final String VELOCITY_TRANSFORMER = "vmTransformer";
    public static final String FREEMARKER_ENGINE = "ftl";
    public static final String FREEMARKER_TRANSFORMER = "ftlTransformer";
    private static final String DEFAULT_CONFIG = "net/sourceforge/rtf/rtftemplate-config.xml";
    private static Map rtfTemplateBuilderMap = new HashMap();
    private ApplicationContext applicationContext;

    private RTFTemplateBuilder() {
    }

    public static RTFTemplateBuilder newRTFTemplateBuilder() {
        RTFTemplateBuilder builder = (RTFTemplateBuilder)rtfTemplateBuilderMap.get(DEFAULT_CONFIG);
        if (builder == null) {
            builder = RTFTemplateBuilder.newRTFTemplateBuilder(DEFAULT_CONFIG, (ApplicationContext)new ClassPathXmlApplicationContext(DEFAULT_CONFIG));
        }
        return builder;
    }

    public static RTFTemplateBuilder newRTFTemplateBuilder(String configLocation) {
        RTFTemplateBuilder builder = (RTFTemplateBuilder)rtfTemplateBuilderMap.get(configLocation);
        if (builder == null) {
            builder = RTFTemplateBuilder.newRTFTemplateBuilder(configLocation, (ApplicationContext)new FileSystemXmlApplicationContext(configLocation));
        }
        return builder;
    }

    public static RTFTemplateBuilder newRTFTemplateBuilder(String key, ApplicationContext applicationContext) {
        RTFTemplateBuilder builder = (RTFTemplateBuilder)rtfTemplateBuilderMap.get(key);
        if (builder == null) {
            builder = RTFTemplateBuilder.newRTFTemplateBuilder(applicationContext);
            rtfTemplateBuilderMap.put(key, builder);
        }
        return builder;
    }

    public static RTFTemplateBuilder newRTFTemplateBuilder(ApplicationContext applicationContext) {
        RTFTemplateBuilder builder = new RTFTemplateBuilder();
        builder.applicationContext = applicationContext;
        return builder;
    }

    public RTFTemplate newRTFTemplate(String rtfTemplateType) throws UnsupportedRTFTemplate {
        RTFTemplate rtfTemplate = (RTFTemplate)this.applicationContext.getBean(rtfTemplateType);
        if (rtfTemplate == null) {
            throw new UnsupportedRTFTemplate(rtfTemplateType);
        }
        return rtfTemplate;
    }

    public RTFTemplate newRTFTemplate() throws UnsupportedRTFTemplate {
        return this.newRTFTemplate(DEFAULT_VELOCITY_RTFTEMPLATE);
    }

    public ITemplateEngine newTemplateEngine(String templateEngineType) throws UnsupportedTemplateEngine {
        ITemplateEngine templateEngine = (ITemplateEngine)this.applicationContext.getBean(templateEngineType);
        if (templateEngine == null) {
            throw new UnsupportedTemplateEngine(templateEngineType);
        }
        return templateEngine;
    }

    public IRTFDocumentTransformer newRTFDocumentTransformer(String rtfDocumentTransformerType) throws UnsupportedRTFDocumentTransformer {
        IRTFDocumentTransformer rtfDocumentTransformer = (IRTFDocumentTransformer)this.applicationContext.getBean(rtfDocumentTransformerType);
        if (rtfDocumentTransformer == null) {
            throw new UnsupportedRTFDocumentTransformer(rtfDocumentTransformerType);
        }
        return rtfDocumentTransformer;
    }

    public IRTFDocumentParser newRTFDocumentParser(String rtfDocumentParserType) throws UnsupportedRTFDocumentParser {
        IRTFDocumentParser rtfDocumentParser = (IRTFDocumentParser)this.applicationContext.getBean(rtfDocumentParserType);
        if (rtfDocumentParser == null) {
            throw new UnsupportedRTFDocumentParser(rtfDocumentParserType);
        }
        return rtfDocumentParser;
    }

    public IRTFDocumentParser newRTFDocumentParser() throws UnsupportedRTFDocumentParser {
        return this.newRTFDocumentParser(DEFAULT_RTFDOCUMENTPARSER);
    }
}

