/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.handler;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.rtf.parser.AbstractCoreRTFParser;

public class RTFIndentHandler
extends AbstractCoreRTFParser {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Writer writer;

    public RTFIndentHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    protected void handleKeyword(String content) throws IOException {
        this.writer.write(content);
    }

    @Override
    protected void startGroup(char startGroupCharacter, int level) throws IOException {
        if (level > 1) {
            this.writer.write(LINE_SEPARATOR);
        }
        this.write(String.valueOf(startGroupCharacter), level);
    }

    @Override
    protected void endGroup(char endGroupCharacter, int level) throws IOException {
        this.writer.write(LINE_SEPARATOR);
        this.write(String.valueOf(endGroupCharacter), level);
    }

    private void write(String content, int level) throws IOException {
        for (int i = 0; i < level - 1; ++i) {
            this.writer.write("    ");
        }
        this.writer.write(content);
    }

    public static void main(String[] args) {
        String rtfSource = "TestIndentReader.rtf";
        if (args != null && args.length > 0) {
            rtfSource = args[0];
        }
        String rtfTarget = "indent_" + rtfSource;
        RTFIndentHandler rtfReader = null;
        try {
            FileWriter writer = new FileWriter(new File(rtfTarget));
            rtfReader = new RTFIndentHandler(writer);
            rtfReader.parse(new FileReader(rtfSource));
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Erreur while RTFIndentHandler : " + e.getMessage());
        }
    }
}

