/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.handler;

import java.io.IOException;
import java.util.Stack;
import net.sourceforge.rtf.IRTFDocumentParser;
import net.sourceforge.rtf.document.RTFAnnotation;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.document.RTFElement;
import net.sourceforge.rtf.document.RTFEndBookmark;
import net.sourceforge.rtf.document.RTFField;
import net.sourceforge.rtf.document.RTFPage;
import net.sourceforge.rtf.document.RTFRow;
import net.sourceforge.rtf.document.RTFStartBookmark;
import net.sourceforge.rtf.document.RTFUserProperty;
import net.sourceforge.rtf.parser.AbstractDefaultRTFParser;

public class RTFDocumentHandler
extends AbstractDefaultRTFParser
implements IRTFDocumentParser {
    private RTFDocument document = null;
    private RTFElement currentRTFElement = null;
    private int currentLevel;
    private RTFElement lastRTFElement = null;
    private Stack lastRTFFields = new Stack();
    private Stack levelOfLastFields = new Stack();
    private String startGroup = null;
    private int levelOfAnnotation = -1;

    @Override
    protected void startGroup(char startGroupCharacter, int level) throws IOException {
        this.currentLevel = level;
        if (level == 1) {
            this.document = new RTFDocument();
            this.currentRTFElement = this.document;
            this.getCurrentRTFElement().addRTFString(String.valueOf(startGroupCharacter));
        } else {
            this.startGroup = this.startGroup == null ? String.valueOf(startGroupCharacter) : this.startGroup + String.valueOf(startGroupCharacter);
        }
    }

    @Override
    protected void endGroup(char endGroupCharacter, int level) throws IOException {
        Integer levelOfLastField;
        this.currentLevel = level;
        if (this.startGroup != null) {
            this.getCurrentRTFElement().addRTFString(this.startGroup);
            this.startGroup = null;
        }
        if (this.lastRTFElement != null) {
            this.lastRTFElement.addRTFString(String.valueOf(endGroupCharacter));
            this.lastRTFElement = null;
            return;
        }
        this.getCurrentRTFElement().addRTFString(String.valueOf(endGroupCharacter));
        int size = this.levelOfLastFields.size();
        if (size > 0 && (levelOfLastField = (Integer)this.levelOfLastFields.get(size - 1)) == level) {
            this.endField();
            return;
        }
        if (this.levelOfAnnotation == this.currentLevel) {
            this.endAnnotation();
        }
    }

    @Override
    protected void startRow(String content) throws IOException {
        RTFRow row = null;
        boolean isNewRow = true;
        if (this.currentRTFElement instanceof RTFRow) {
            row = (RTFRow)this.currentRTFElement;
            isNewRow = false;
        } else {
            row = new RTFRow();
        }
        if (this.startGroup != null) {
            row.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        row.addRTFString(content);
        if (isNewRow) {
            this.getCurrentRTFElement().addRTFElement(row);
        }
        this.currentRTFElement = row;
    }

    @Override
    protected void endRow(String content) throws IOException {
        if (this.startGroup != null) {
            this.getCurrentRTFElement().addRTFString(this.startGroup);
            this.startGroup = null;
        }
        this.lastRTFElement = this.getCurrentRTFElement();
        this.getCurrentRTFElement().addRTFString(content);
        this.currentRTFElement = this.currentRTFElement.getRtfElementParent();
    }

    @Override
    protected void inTable(String content) throws IOException {
        if (this.currentRTFElement instanceof RTFDocument) {
            RTFRow row = new RTFRow();
            row.addRTFString(this.getCurrentRTFElement().removeCurrentRTFString().toString());
            this.getCurrentRTFElement().addRTFElement(row);
            this.currentRTFElement = row;
        }
        this.currentRTFElement.addRTFString(content);
    }

    @Override
    protected void startField(String content) throws IOException {
        RTFField field = new RTFField();
        if (this.startGroup != null) {
            field.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        field.addRTFString(content);
        RTFElement element = this.getCurrentRTFElement();
        if (element instanceof RTFRow) {
            RTFRow rtfRow = (RTFRow)element;
            rtfRow.addRTFField(field);
        } else {
            this.getCurrentRTFElement().addRTFElement(field);
        }
        this.currentRTFElement = field;
        this.lastRTFFields.add(field);
        this.levelOfLastFields.add(new Integer(this.currentLevel));
    }

    protected void endField() throws IOException {
        RTFField field = (RTFField)this.lastRTFFields.pop();
        this.levelOfLastFields.pop();
        field.getName();
        if (this.currentRTFElement instanceof RTFField) {
            this.currentRTFElement = this.currentRTFElement.getRtfElementParent();
        }
    }

    @Override
    protected void startBookmark(String content) throws IOException {
        RTFStartBookmark bookmark = new RTFStartBookmark();
        if (this.startGroup != null) {
            bookmark.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        bookmark.addRTFString(content);
        this.getCurrentRTFElement().addRTFElement(bookmark);
        this.lastRTFElement = bookmark;
    }

    @Override
    protected void endBookmark(String content) throws IOException {
        RTFEndBookmark bookmark = new RTFEndBookmark();
        if (this.startGroup != null) {
            bookmark.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        bookmark.addRTFString(content);
        this.getCurrentRTFElement().addRTFElement(bookmark);
        this.lastRTFElement = bookmark;
    }

    @Override
    protected void startPage(String content) throws IOException {
        RTFPage page = new RTFPage();
        page.addRTFString(content);
        this.currentRTFElement.addRTFElement(page);
    }

    @Override
    protected void startUserProperty(String content) throws IOException {
        RTFUserProperty userProperty = new RTFUserProperty();
        if (this.startGroup != null) {
            userProperty.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        userProperty.addRTFString(content);
        this.getCurrentRTFElement().addRTFElement(userProperty);
        this.currentRTFElement = userProperty;
    }

    @Override
    protected void endUserProperty(String content) throws IOException {
        RTFUserProperty userProperty = (RTFUserProperty)this.currentRTFElement;
        if (this.startGroup != null) {
            userProperty.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        userProperty.addRTFString(content);
        userProperty.getName();
        this.lastRTFElement = userProperty;
        this.currentRTFElement = this.currentRTFElement.getRtfElementParent();
    }

    @Override
    protected void startAnnotation(String content) throws IOException {
        RTFAnnotation annotation = new RTFAnnotation();
        if (this.startGroup != null) {
            annotation.addRTFString(this.startGroup);
            this.startGroup = null;
        }
        annotation.addRTFString(content);
        this.getCurrentRTFElement().addRTFElement(annotation);
        this.currentRTFElement = annotation;
        this.levelOfAnnotation = this.currentLevel;
    }

    protected void endAnnotation() {
        this.levelOfAnnotation = -1;
        if (this.currentRTFElement instanceof RTFAnnotation) {
            this.currentRTFElement = this.currentRTFElement.getRtfElementParent();
        }
    }

    @Override
    protected void handleText(String content) throws IOException {
        if (this.startGroup != null) {
            this.getCurrentRTFElement().addRTFString(this.startGroup);
            this.startGroup = null;
        }
        this.getCurrentRTFElement().addRTFString(content);
    }

    private RTFElement getCurrentRTFElement() throws IOException {
        if (this.currentRTFElement == null) {
            throw new IOException("Current RTF element is null. RTF stream is not valid.");
        }
        return this.currentRTFElement;
    }

    @Override
    public RTFDocument getRTFDocument() {
        return this.document;
    }
}

