/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.document.transformer.config;

public class TransformerConfig {
    private static final String PATTERN_BOOKMARK_PARAMETER = "\\{i\\}";
    public static final String START_LOOP_BOOKMARK_TYPE = "START_LOOP";
    public static final String END_LOOP_BOOKMARK_TYPE = "END_LOOP";
    public static final String IF_BOOKMARK_TYPE = "IF";
    public static final String ELSE_BOOKMARK_TYPE = "ELSE";
    public static final String ENDIF_BOOKMARK_TYPE = "ENDIF";
    public static String DEFAULT_IF_PATTERN = "IF_{i}";
    public static String DEFAULT_ELSE_PATTERN = "ELSE_{i}";
    public static String DEFAULT_ENDIF_PATTERN = "ENDIF_{i}";
    private String bookmarkStartLoopPattern;
    private String bookmarkEndLoopPattern;
    private String bookmarkStartLoopWithoutBookmarkParameter = null;
    private String bookmarkEndLoopWithoutBookmarkParameter = null;
    private String bookmarkIfPattern;
    private String bookmarkIfWithoutBookmarkParameter = null;
    private String bookmarkEndIfPattern;
    private String bookmarkEndIfWithoutBookmarkParameter = null;
    private String bookmarkElsePattern;
    private String bookmarkElseWithoutBookmarkParameter = null;

    public String getBookmarkStartLoopName(int index) {
        return this.bookmarkStartLoopPattern.replaceAll(PATTERN_BOOKMARK_PARAMETER, String.valueOf(index));
    }

    public String getBookmarkEndLoopName(int index) {
        return this.bookmarkEndLoopPattern.replaceAll(PATTERN_BOOKMARK_PARAMETER, String.valueOf(index));
    }

    public int getBookmarkIndex(String bookmarkName) {
        int index = -1;
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        String bookmarkIndex = bookmarkName.replaceAll(bookmarkWithoutNumber, "");
        try {
            index = Integer.parseInt(bookmarkIndex);
        }
        catch (Exception e) {
            // empty catch block
        }
        return index;
    }

    public boolean isBookmarkStartLoop(String bookmarkName) {
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        return bookmarkWithoutNumber.startsWith(this.getBookmarkStartLoopWithoutBookmarkParameter());
    }

    public boolean isBookmarkEndLoop(String bookmarkName) {
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        return bookmarkWithoutNumber.startsWith(this.getBookmarkEndLoopWithoutBookmarkParameter());
    }

    public String getBookmarkEndLoopPattern() {
        return this.bookmarkEndLoopPattern;
    }

    public void setBookmarkEndLoopPattern(String bookmarkEndLoopPattern) {
        this.bookmarkEndLoopPattern = bookmarkEndLoopPattern;
    }

    public String getBookmarkStartLoopPattern() {
        return this.bookmarkStartLoopPattern;
    }

    public void setBookmarkStartLoopPattern(String bookmarkStartLoopPattern) {
        this.bookmarkStartLoopPattern = bookmarkStartLoopPattern;
    }

    public String getBookmarkEndLoopWithoutBookmarkParameter() {
        if (this.bookmarkEndLoopWithoutBookmarkParameter == null) {
            String firstBookmark = this.getBookmarkEndLoopName(1);
            this.bookmarkEndLoopWithoutBookmarkParameter = this.removeNumber(firstBookmark);
        }
        return this.bookmarkEndLoopWithoutBookmarkParameter;
    }

    public String getBookmarkStartLoopWithoutBookmarkParameter() {
        if (this.bookmarkStartLoopWithoutBookmarkParameter == null) {
            String firstBookmark = this.getBookmarkStartLoopName(1);
            this.bookmarkStartLoopWithoutBookmarkParameter = this.removeNumber(firstBookmark);
        }
        return this.bookmarkStartLoopWithoutBookmarkParameter;
    }

    private String removeNumber(String value) {
        return value.replaceAll("[0-9]", "");
    }

    public String getBookmarkIfPattern() {
        if (this.bookmarkIfPattern == null) {
            return DEFAULT_IF_PATTERN;
        }
        return this.bookmarkIfPattern;
    }

    public String getBookmarkEndIfPattern() {
        if (this.bookmarkEndIfPattern == null) {
            return DEFAULT_ENDIF_PATTERN;
        }
        return this.bookmarkEndIfPattern;
    }

    public String getBookmarkElsePattern() {
        if (this.bookmarkElsePattern == null) {
            return DEFAULT_ELSE_PATTERN;
        }
        return this.bookmarkElsePattern;
    }

    public void setBookmarkIfPattern(String bookmarkIfPattern) {
        this.bookmarkIfPattern = bookmarkIfPattern;
    }

    public String getBookmarkIfName(int index) {
        return this.getBookmarkIfPattern().replaceAll(PATTERN_BOOKMARK_PARAMETER, String.valueOf(index));
    }

    public void setBookmarkEndIfPattern(String bookmarkEndIfPattern) {
        this.bookmarkEndIfPattern = bookmarkEndIfPattern;
    }

    public String getBookmarkEndIfName(int index) {
        return this.getBookmarkEndIfPattern().replaceAll(PATTERN_BOOKMARK_PARAMETER, String.valueOf(index));
    }

    public void setBookmarkElsePattern(String bookmarkElsePattern) {
        this.bookmarkElsePattern = bookmarkElsePattern;
    }

    public String getBookmarkElseName(int index) {
        return this.getBookmarkElsePattern().replaceAll(PATTERN_BOOKMARK_PARAMETER, String.valueOf(index));
    }

    public String getBookmarkIfWithoutBookmarkParameter() {
        if (this.bookmarkIfWithoutBookmarkParameter == null) {
            String firstBookmark = this.getBookmarkIfName(1);
            this.bookmarkIfWithoutBookmarkParameter = this.removeNumber(firstBookmark);
        }
        return this.bookmarkIfWithoutBookmarkParameter;
    }

    public String getBookmarkEndIfWithoutBookmarkParameter() {
        if (this.bookmarkEndIfWithoutBookmarkParameter == null) {
            String firstBookmark = this.getBookmarkEndIfName(1);
            this.bookmarkEndIfWithoutBookmarkParameter = this.removeNumber(firstBookmark);
        }
        return this.bookmarkEndIfWithoutBookmarkParameter;
    }

    public String getBookmarkElseWithoutBookmarkParameter() {
        if (this.bookmarkElseWithoutBookmarkParameter == null) {
            String firstBookmark = this.getBookmarkElseName(1);
            this.bookmarkElseWithoutBookmarkParameter = this.removeNumber(firstBookmark);
        }
        return this.bookmarkElseWithoutBookmarkParameter;
    }

    public boolean isBookmarkIf(String bookmarkName) {
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        return bookmarkWithoutNumber.startsWith(this.getBookmarkIfWithoutBookmarkParameter());
    }

    public boolean isBookmarkEndIf(String bookmarkName) {
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        return bookmarkWithoutNumber.startsWith(this.getBookmarkEndIfWithoutBookmarkParameter());
    }

    public boolean isBookmarkElse(String bookmarkName) {
        String bookmarkWithoutNumber = this.removeNumber(bookmarkName);
        return bookmarkWithoutNumber.startsWith(this.getBookmarkElseWithoutBookmarkParameter());
    }
}

