/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.document.transformer.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class DigesterTransformerConfig {
    private static final String DEFAULT_XML_TRANSFORMER_CONFIG = "transformer-config.xml";

    public static TransformerConfig getTransformerConfig() throws SAXException, IOException {
        InputStream inputStream = DigesterTransformerConfig.class.getResourceAsStream(DEFAULT_XML_TRANSFORMER_CONFIG);
        return DigesterTransformerConfig.getTransformerConfig(inputStream);
    }

    public static TransformerConfig getTransformerConfig(String configFileName) throws SAXException, IOException {
        return DigesterTransformerConfig.getTransformerConfig(new File(configFileName));
    }

    public static TransformerConfig getTransformerConfig(File configFile) throws SAXException, IOException {
        return DigesterTransformerConfig.getTransformerConfig(new FileInputStream(configFile));
    }

    public static TransformerConfig getTransformerConfig(InputStream inputStream) throws SAXException, IOException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("transformer-config", TransformerConfig.class);
        digester.addBeanPropertySetter("transformer-config/bookmark-start-loop/pattern", "bookmarkStartLoopPattern");
        digester.addBeanPropertySetter("transformer-config/bookmark-end-loop/pattern", "bookmarkEndLoopPattern");
        digester.addBeanPropertySetter("transformer-config/bookmark-if/pattern", "bookmarkIfPattern");
        digester.addBeanPropertySetter("transformer-config/bookmark-end-if/pattern", "bookmarkEndIfPattern");
        digester.addBeanPropertySetter("transformer-config/bookmark-else/pattern", "bookmarkElsePattern");
        return (TransformerConfig)digester.parse(inputStream);
    }

    public static void main(String[] args) {
        try {
            TransformerConfig transformerConfig = DigesterTransformerConfig.getTransformerConfig();
            System.out.println("BookmarkStartLoopPattern : " + transformerConfig.getBookmarkStartLoopPattern());
            System.out.println("BookmarkEndLoopPattern : " + transformerConfig.getBookmarkEndLoopPattern());
        }
        catch (Exception e) {
            System.out.println("Error while digester transformer config : " + e.getMessage());
        }
    }
}

