/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.document;

import net.sourceforge.rtf.document.RTFElement;

public class RTFField
extends RTFElement {
    public static final int FIELDTYPE_UNKNOW = 0;
    public static final int FIELDTYPE_MERGEFIELD = 1;
    public static final int FIELDTYPE_HYPERLINK = 2;
    public static final int FIELDTYPE_FORMTEXT = 3;
    public static final int FIELDTYPE_REF = 4;
    private String name = null;
    private int type;
    private String condition = null;

    public RTFField() {
        this.type = 0;
    }

    public RTFField(RTFField field) {
        super(field);
    }

    public String getName() {
        String rtfContent;
        if (this.name == null && (rtfContent = this.getRTFContentOfSimpleElement()) != null) {
            this.name = this.getElementTextBetween(rtfContent, "MERGEFIELD", "\\");
            if (this.name != null) {
                this.type = 1;
            } else {
                this.name = this.getElementTextBetween(rtfContent, "HYPERLINK", "\\");
                if (this.name != null) {
                    this.name = this.name.replaceAll("mailto:", "");
                    this.type = 2;
                } else if (rtfContent.indexOf("FORMTEXT") != -1) {
                    this.name = this.getElementTextBetween(rtfContent, "\\ffdeftext", "}");
                    this.type = 3;
                } else {
                    int spaceIndex;
                    String content = this.getElementTextBetween(rtfContent, " REF ", "}");
                    if (content != null && (spaceIndex = content.indexOf(" ")) != -1) {
                        this.name = content.substring(0, spaceIndex);
                        this.condition = content.substring(spaceIndex + 1, content.length());
                        this.type = 4;
                    }
                }
            }
            if (this.name != null) {
                this.name = this.name.replaceAll("\"", "");
                this.name = this.name.replaceAll("\\}", "");
                this.name = this.name.replaceAll("\\{", "");
                this.name = this.name.trim();
            }
        }
        return this.name;
    }

    public int getType() {
        if (this.type == -1) {
            this.getName();
        }
        return this.type;
    }

    public String getCondition() {
        return this.condition;
    }
}

