/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.document;

import java.util.Vector;

public class RTFElement {
    private Vector elementList = null;
    private StringBuffer currentRTFString = null;
    private RTFElement rtfElementParent = null;
    private String firstRTFString = null;
    private String lastRTFString = null;

    public RTFElement() {
        this.elementList = new Vector();
    }

    public StringBuffer removeCurrentRTFString() {
        if (this.currentRTFString == null) {
            return new StringBuffer();
        }
        this.elementList.remove(this.currentRTFString);
        StringBuffer ret = this.currentRTFString;
        this.currentRTFString = null;
        return ret;
    }

    public RTFElement(RTFElement element) {
        this.elementList = (Vector)element.elementList.clone();
    }

    public void addRTFElement(RTFElement element) {
        this.currentRTFString = null;
        element.setRtfElementParent(this);
        this.elementList.add(element);
    }

    public void addRTFString(String rtfContent) {
        if (this.currentRTFString == null) {
            this.currentRTFString = new StringBuffer();
            this.elementList.add(this.currentRTFString);
        }
        this.currentRTFString.append(rtfContent);
    }

    public void flush() {
        if (this.firstRTFString != null) {
            this.elementList.add(0, new StringBuffer(this.firstRTFString));
            this.firstRTFString = null;
        }
        if (this.lastRTFString != null) {
            this.elementList.add(new StringBuffer(this.lastRTFString));
            this.lastRTFString = null;
        }
    }

    public String getFirstRTFString() {
        return this.firstRTFString;
    }

    public void addFirstRTFString(String rtfContent) {
        this.firstRTFString = rtfContent;
    }

    public void addLastRTFString(String rtfContent) {
        this.lastRTFString = rtfContent;
    }

    public Vector getElementList() {
        return this.elementList;
    }

    public RTFElement getRtfElementParent() {
        return this.rtfElementParent;
    }

    public void setRtfElementParent(RTFElement rtfElementParent) {
        this.rtfElementParent = rtfElementParent;
    }

    public void replaceElement(String content) {
        this.elementList = new Vector();
        this.currentRTFString = null;
        this.addRTFString(content);
    }

    public String getRTFContentOfSimpleElement() {
        StringBuffer rtfContent;
        Vector elementList = this.getElementList();
        if (elementList != null && elementList.size() == 1 && (rtfContent = (StringBuffer)elementList.get(0)) != null) {
            String content = rtfContent.toString();
            content = content.replaceAll("\r", "");
            content = content.replaceAll("\n", "");
            return content;
        }
        return null;
    }

    public String getRTFFirstContentOfElement() {
        StringBuffer rtfContent;
        Vector elementList = this.getElementList();
        if (elementList != null && elementList.size() > 0 && (rtfContent = (StringBuffer)elementList.get(0)) != null) {
            String content = rtfContent.toString();
            content = content.replaceAll("\r", "");
            content = content.replaceAll("\n", "");
            return content;
        }
        return null;
    }

    protected String getElementTextBetween(String rtfContent, String startToken, String endToken) {
        if (rtfContent != null) {
            String content = rtfContent;
            int indexStartToken = content.indexOf(startToken);
            int indexEndToken = content.indexOf(endToken, indexStartToken);
            if (indexStartToken != -1 && indexEndToken != -1) {
                return content.substring(indexStartToken += startToken.length(), indexEndToken).trim();
            }
        }
        return null;
    }
}

