/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.document;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sourceforge.rtf.document.RTFElement;

public class RTFDocument
extends RTFElement {
    private List stringBufferList = null;

    public RTFDocument() {
    }

    public RTFDocument(RTFDocument document) {
        super(document);
    }

    public void save(String fileName) throws IOException {
        File file = new File(fileName);
        this.save(file);
    }

    public void save(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.save(writer);
    }

    public void save(Writer writer) throws IOException {
        List rtfStringList = this.getAllRTFStringList();
        for (String stringElement : rtfStringList) {
            writer.write(stringElement);
        }
        writer.close();
    }

    public Reader getReader() throws IOException {
        return new RTFDocumentReader(this);
    }

    private List getAllRTFStringList() throws IOException {
        if (this.stringBufferList == null) {
            this.stringBufferList = new ArrayList();
            Vector elementList = this.getElementList();
            this.setAllRTFStringList(elementList);
        }
        return this.stringBufferList;
    }

    private void setAllRTFStringList(Vector elementList) throws IOException {
        for (Object element : elementList) {
            if (element instanceof StringBuffer) {
                StringBuffer stringElement = (StringBuffer)element;
                if (stringElement == null || stringElement.length() <= 0) continue;
                this.stringBufferList.add(stringElement.toString());
                continue;
            }
            if (element instanceof RTFElement) {
                RTFElement rtfElement = (RTFElement)element;
                this.setAllRTFStringList(rtfElement.getElementList());
                continue;
            }
            throw new IOException("Error while save RTFDocument. RTFDocument must contain RTFElement or StringBuffer.");
        }
    }

    private class RTFDocumentReader
    extends Reader {
        private Reader reader;
        private int index;
        private int size;
        private List rtfStringList = null;

        public RTFDocumentReader(RTFDocument document) throws IOException {
            this.rtfStringList = document.getAllRTFStringList();
            this.size = this.rtfStringList.size();
            this.index = 0;
            this.createReader(this.index++);
        }

        @Override
        public int read() throws IOException {
            int ch = this.reader.read();
            if (ch == -1 && this.nextReader()) {
                ch = this.reader.read();
            }
            return ch;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int ct = this.reader.read(cbuf, off, len);
            if (ct == -1 && this.nextReader()) {
                ct = this.reader.read(cbuf, off, len);
            }
            return ct;
        }

        @Override
        public void close() throws IOException {
        }

        private boolean nextReader() throws IOException {
            if (this.size > this.index) {
                this.createReader(this.index++);
                return true;
            }
            return false;
        }

        private void createReader(int index) throws IOException {
            String rtfString = (String)this.rtfStringList.get(index);
            this.reader = new StringReader(rtfString);
        }
    }
}

