/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.context.image;

import net.sourceforge.rtf.context.image.ImageUtil;

public class FormatBase {
    public static boolean isFormat(byte[] data) {
        return false;
    }

    public FormatBase convert(FormatBase format, byte[] data) {
        return format;
    }

    public static FormatBase determineFormat(byte[] data) {
        if (FormatPNG.isFormat(data)) {
            return new FormatPNG();
        }
        if (FormatJPG.isFormat(data)) {
            return new FormatJPG();
        }
        if (FormatEMF.isFormat(data)) {
            return new FormatEMF();
        }
        if (FormatGIF.isFormat(data)) {
            return new FormatGIF();
        }
        if (FormatBMP.isFormat(data)) {
            return new FormatBMP();
        }
        return null;
    }

    public int getType() {
        return -1;
    }

    public String getRtfTag() {
        return "";
    }

    private static class FormatPNG
    extends FormatBase {
        private FormatPNG() {
        }

        public static boolean isFormat(byte[] data) {
            byte[] pattern = new byte[]{80, 78, 71};
            return ImageUtil.compareHexValues(pattern, data, 1, true);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public String getRtfTag() {
            return "pngblip";
        }
    }

    private static class FormatJPG
    extends FormatBase {
        private FormatJPG() {
        }

        public static boolean isFormat(byte[] data) {
            byte[] pattern = new byte[]{-1, -40};
            return ImageUtil.compareHexValues(pattern, data, 0, true);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public String getRtfTag() {
            return "jpegblip";
        }
    }

    private static class FormatBMP
    extends FormatBase {
        private FormatBMP() {
        }

        public static boolean isFormat(byte[] data) {
            byte[] pattern = new byte[]{66, 77};
            return ImageUtil.compareHexValues(pattern, data, 0, true);
        }

        @Override
        public int getType() {
            return 3;
        }
    }

    private static class FormatEMF
    extends FormatBase {
        private FormatEMF() {
        }

        public static boolean isFormat(byte[] data) {
            byte[] pattern = new byte[]{1, 0, 0};
            return ImageUtil.compareHexValues(pattern, data, 0, true);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public String getRtfTag() {
            return "emfblip";
        }
    }

    private static class FormatGIF
    extends FormatBase {
        private FormatGIF() {
        }

        public static boolean isFormat(byte[] data) {
            byte[] pattern = new byte[]{71, 73, 70, 56};
            return ImageUtil.compareHexValues(pattern, data, 0, true);
        }

        @Override
        public int getType() {
            return 50;
        }
    }
}

