/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.context.fields;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.rtf.context.fields.RTFContextBookmark;
import net.sourceforge.rtf.context.fields.RTFContextField;

public class RTFContextFields {
    private String description = null;
    private List mergeFields = new ArrayList();
    private Map mergeFieldsMap = null;
    private List bookmarks = new ArrayList();
    private Map bookmarksMap = null;

    public void addMergeField(RTFContextField mergeField) {
        this.mergeFields.add(mergeField);
    }

    public List getMergeFields() {
        return this.mergeFields;
    }

    public Map getMergeFieldsMap() {
        if (this.mergeFieldsMap == null) {
            this.mergeFieldsMap = new HashMap();
            for (RTFContextField element : this.getMergeFields()) {
                this.mergeFieldsMap.put(element.getName(), element);
            }
        }
        return this.mergeFieldsMap;
    }

    public void addBookmark(RTFContextBookmark bookmark) {
        this.bookmarks.add(bookmark);
    }

    public List getBookmarks() {
        return this.bookmarks;
    }

    public Map getBookmarksMap() {
        if (this.bookmarksMap == null) {
            this.bookmarksMap = new HashMap();
            for (RTFContextBookmark element : this.getBookmarks()) {
                this.bookmarksMap.put(element.getType(), element);
            }
        }
        return this.bookmarksMap;
    }

    public void toXml(String filename) throws FileNotFoundException {
        this.toXml(new File(filename));
    }

    public void toXml(File filePath) throws FileNotFoundException {
        PrintStream p = new PrintStream(new FileOutputStream(filePath, false));
        p.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        p.println("<fields>");
        String fieldsDescription = this.getDescription();
        if (fieldsDescription == null) {
            fieldsDescription = "";
        }
        p.println("\t<description><![CDATA[" + fieldsDescription + "]]></description>");
        for (Object element : this.getBookmarks()) {
            this.toXml(p, (RTFContextBookmark)element);
        }
        for (Object element : this.getMergeFields()) {
            this.toXml(p, (RTFContextField)element);
        }
        p.println("</fields>");
        p.flush();
        p.close();
    }

    private void toXml(PrintStream p, RTFContextBookmark bookmark) {
        String bookmarkType = bookmark.getType();
        String bookmarkName = bookmark.getName();
        String bookmarkDescription = bookmark.getDescription();
        if (bookmarkDescription == null) {
            bookmarkDescription = "";
        }
        p.println("\t<bookmark>");
        p.println("\t\t<type>" + bookmarkType + "</type>");
        p.println("\t\t<name>" + bookmarkName + "</name>");
        p.println("\t\t<description><![CDATA[" + bookmarkDescription + "]]></description>");
        p.println("\t</bookmark>");
    }

    private void toXml(PrintStream p, RTFContextField field) {
        boolean isMergeFieldList = field.isList();
        String listInfo = field.getListInfo();
        String mergeFieldName = field.getName();
        String mergeFieldDescription = field.getDescription();
        if (mergeFieldDescription == null) {
            mergeFieldDescription = "";
        }
        p.println("\t<mergefield>");
        p.println("\t\t<list>" + String.valueOf(isMergeFieldList) + "</list>");
        p.println("\t\t<listInfo>" + listInfo + "</listInfo>");
        p.println("\t\t<name>" + mergeFieldName + "</name>");
        p.println("\t\t<description><![CDATA[" + mergeFieldDescription + "]]></description>");
        p.println("\t</mergefield>");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

