/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.context;

import net.sourceforge.rtf.context.AbstractRTFContextReader;

public class RTFXmlFieldsReader
extends AbstractRTFContextReader {
    private String bookmarkStartLoop = "START_LOOP";
    private String bookmarkEndLoop = "END_LOOP";
    private StringBuffer xmlContext;

    @Override
    protected void startReading() {
        this.xmlContext = new StringBuffer("");
        this.xmlContext.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.xmlContext.append("<fields>\n");
    }

    @Override
    protected void endReading() {
        this.xmlContext.append("</fields>");
    }

    @Override
    protected void addMergeField(String mergeFieldName, boolean mergeFieldIsList, String listInfo, boolean isImage) {
        this.xmlContext.append("\t<mergefield>\n");
        this.xmlContext.append("\t\t<list>");
        this.xmlContext.append(String.valueOf(mergeFieldIsList));
        this.xmlContext.append("</list>\n");
        if (listInfo != null && listInfo.length() > 0) {
            this.xmlContext.append("\t\t<listInfo>");
            this.xmlContext.append(listInfo);
            this.xmlContext.append("</listInfo>\n");
        }
        if (isImage) {
            this.xmlContext.append("\t\t<image>");
            this.xmlContext.append(String.valueOf(isImage));
            this.xmlContext.append("</image>\n");
        }
        this.xmlContext.append("\t\t<name>");
        this.xmlContext.append(mergeFieldName);
        this.xmlContext.append("</name>\n");
        this.xmlContext.append("\t\t<description><![CDATA[...]]></description>\n");
        this.xmlContext.append("\t</mergefield>\n");
    }

    protected void addBookmarks() {
        this.addBookmark(this.bookmarkStartLoop, this.bookmarkStartLoop);
        this.addBookmark(this.bookmarkEndLoop, this.bookmarkEndLoop);
    }

    @Override
    protected void addBookmark(String bookmarkName, String bookmarkType) {
        this.xmlContext.append("\t<bookmark>\n");
        this.xmlContext.append("\t\t<type>");
        this.xmlContext.append(bookmarkType);
        this.xmlContext.append("</type>\n");
        this.xmlContext.append("\t\t<name>");
        this.xmlContext.append(bookmarkName);
        this.xmlContext.append("</name>\n");
        this.xmlContext.append("\t\t<description><![CDATA[...]]></description>\n");
        this.xmlContext.append("\t</bookmark>\n");
    }

    public String getXMLFields() {
        return this.xmlContext.toString();
    }
}

