/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.context;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.rtf.context.DigesterRTFContextFields;
import net.sourceforge.rtf.context.fields.RTFContextBookmark;
import net.sourceforge.rtf.context.fields.RTFContextField;
import net.sourceforge.rtf.context.fields.RTFContextFields;
import org.xml.sax.SAXException;

public class RTFContextUtil {
    public static boolean isList(Object o) {
        return o instanceof Collection;
    }

    public static void saveXmlFields(String fileXmlFields, RTFContextFields newFields, boolean force) throws SAXException, IOException {
        RTFContextUtil.saveXmlFields(fileXmlFields, newFields, fileXmlFields, force);
    }

    public static void saveXmlFields(String inFileXmlFields, RTFContextFields newFields, String outFileXmlFields, boolean force) throws SAXException, IOException {
        File inFile;
        if (!force && (inFile = new File(inFileXmlFields)).exists()) {
            RTFContextFields oldFields = DigesterRTFContextFields.getRTFContextFields(inFile);
            newFields.setDescription(oldFields.getDescription());
            Map oldContextFieldsMap = oldFields.getMergeFieldsMap();
            for (RTFContextField newField : newFields.getMergeFields()) {
                RTFContextField oldField = (RTFContextField)oldContextFieldsMap.get(newField.getName());
                if (oldField == null) continue;
                newField.setDescription(oldField.getDescription());
            }
            Map oldContextBookmarksMap = oldFields.getBookmarksMap();
            for (RTFContextBookmark newBookmark : newFields.getBookmarks()) {
                RTFContextBookmark oldBookmark = (RTFContextBookmark)oldContextBookmarksMap.get(newBookmark.getType());
                if (oldBookmark == null) continue;
                newBookmark.setDescription(oldBookmark.getDescription());
            }
        }
        newFields.toXml(outFileXmlFields);
    }
}

