/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf.context;

import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.rtf.context.RTFContextUtil;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import net.sourceforge.rtf.format.rtfcode.IRTFCode;
import net.sourceforge.rtf.template.IContext;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractRTFContextReader {
    private List excludedPackages = null;
    private boolean circularReferences = false;

    public AbstractRTFContextReader() {
        this.excludedPackages = new ArrayList();
        this.excludePackageName("java.");
    }

    public AbstractRTFContextReader(List excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void excludePackageName(String packageName) {
        this.excludedPackages.add(packageName);
    }

    public void readContext(IContext context, TransformerConfig transformerConfig, boolean circularReferences) {
        this.circularReferences = circularReferences;
        this.startReading();
        if (transformerConfig != null) {
            String bookmarkName = transformerConfig.getBookmarkStartLoopPattern();
            this.addBookmark(bookmarkName, "START_LOOP");
            bookmarkName = transformerConfig.getBookmarkEndLoopPattern();
            this.addBookmark(bookmarkName, "END_LOOP");
            bookmarkName = transformerConfig.getBookmarkIfPattern();
            this.addBookmark(bookmarkName, "IF");
        }
        this.read(context.getGlobalContext());
        this.read(context);
        this.endReading();
    }

    public void readContext(IContext context, boolean circularReferences) {
        this.readContext(context, null, circularReferences);
    }

    private void read(IContext context) {
        Object[] keys;
        if (context != null && (keys = context.getKeys()) != null) {
            for (int kk = 0; kk < keys.length; ++kk) {
                String key = (String)keys[kk];
                Object objectValue = context.get(key);
                String keyWithListInfo = key;
                if (this.isList(objectValue)) {
                    keyWithListInfo = "[" + key + "]";
                }
                ArrayList objectsClassAlreadyParsed = this.circularReferences ? new ArrayList() : null;
                this.parseObject(key, objectValue, keyWithListInfo, objectsClassAlreadyParsed);
            }
        }
    }

    private void parseObject(String objectName, Object objectValue, String objectNameWithListInfo, List objectsClassAlreadyParsed) {
        block14: {
            String mergeFieldName = null;
            String mergeFieldNameWithListInfo = null;
            boolean mergeFieldIsList = this.isList(objectValue);
            boolean isMergeField = false;
            if (mergeFieldIsList) {
                objectValue = this.getFirstObject((Collection)objectValue);
            }
            boolean bl = isMergeField = objectValue != null;
            if (!isMergeField) break block14;
            if (this.isJavaObjectToExlude(objectValue)) {
                if (objectValue instanceof Map) {
                    Map objectValueMap = (Map)objectValue;
                    for (Object element : objectValueMap.keySet()) {
                        if (!(element instanceof String)) continue;
                        String elementName = (String)element;
                        boolean isImage = this.isImage(objectValue);
                        mergeFieldName = this.getMergeFieldName(objectName, elementName, false, false);
                        mergeFieldNameWithListInfo = this.getMergeFieldName(objectNameWithListInfo, elementName, false, false);
                        this.addMergeField(mergeFieldName, mergeFieldIsList, mergeFieldNameWithListInfo, isImage);
                    }
                } else {
                    boolean isImage = this.isImage(objectValue.getClass());
                    mergeFieldName = this.getMergeFieldName(objectName, "");
                    mergeFieldNameWithListInfo = this.getMergeFieldName(objectNameWithListInfo, "", true, true);
                    this.addMergeField(mergeFieldName, mergeFieldIsList, mergeFieldNameWithListInfo, isImage);
                }
            } else {
                PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)objectValue);
                for (int i = 0; i < origDescriptors.length; ++i) {
                    PropertyDescriptor currentDescriptor = origDescriptors[i];
                    String getterName = currentDescriptor.getName();
                    if (getterName.equals("class")) continue;
                    Object objectGetterName = null;
                    try {
                        objectGetterName = PropertyUtils.getProperty((Object)objectValue, (String)getterName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (objectGetterName != null && this.isList(objectGetterName)) {
                        mergeFieldName = this.getMergeFieldName(objectName, getterName);
                        mergeFieldNameWithListInfo = this.getMergeFieldName(objectNameWithListInfo, getterName, true, true);
                        this.parseObject(mergeFieldName, objectGetterName, mergeFieldNameWithListInfo, objectsClassAlreadyParsed);
                        continue;
                    }
                    if (objectGetterName != null && !this.isJavaObjectToExlude(objectGetterName)) {
                        if (this.circularReferences && (!this.circularReferences || objectsClassAlreadyParsed.contains(objectGetterName.getClass()))) continue;
                        if (this.circularReferences) {
                            objectsClassAlreadyParsed.add(objectGetterName.getClass());
                        }
                        this.parseObject(objectName + "." + getterName, objectGetterName, objectNameWithListInfo + "." + getterName, objectsClassAlreadyParsed);
                        if (!this.circularReferences) continue;
                        objectsClassAlreadyParsed.remove(objectGetterName.getClass());
                        continue;
                    }
                    mergeFieldName = this.getMergeFieldName(objectName, getterName);
                    mergeFieldNameWithListInfo = this.getMergeFieldName(objectNameWithListInfo, getterName);
                    boolean isImage = false;
                    if (objectGetterName != null) {
                        isImage = this.isImage(objectGetterName.getClass());
                    }
                    if (mergeFieldNameWithListInfo != null && mergeFieldNameWithListInfo.length() > 0) {
                        mergeFieldIsList = mergeFieldNameWithListInfo.indexOf("[") != -1;
                    }
                    this.addMergeField(mergeFieldName, mergeFieldIsList, mergeFieldNameWithListInfo, isImage);
                }
            }
        }
    }

    private Object getFirstObject(Collection objectCollection) {
        Iterator iter;
        Object objectValue = null;
        if (objectCollection.size() > 0 && (iter = objectCollection.iterator()).hasNext()) {
            objectValue = iter.next();
        }
        return objectValue;
    }

    private boolean isList(Object objectType) {
        return RTFContextUtil.isList(objectType);
    }

    private String getMergeFieldName(String objectName, String getterName) {
        return this.getMergeFieldName(objectName, getterName, false, true);
    }

    private String getMergeFieldName(String objectName, String getterName, boolean addArray, boolean mustUpperCaseOnfirstChar) {
        String fullObjectName = "";
        int getterNameLength = getterName.length();
        switch (getterNameLength) {
            case 0: {
                fullObjectName = objectName;
                break;
            }
            case 1: {
                fullObjectName = objectName + "." + getterName.toUpperCase();
                break;
            }
            default: {
                String characterFirst = getterName.substring(0, 1);
                if (mustUpperCaseOnfirstChar) {
                    characterFirst = characterFirst.toUpperCase();
                }
                getterName = characterFirst + getterName.substring(1, getterName.length());
                if (addArray) {
                    getterName = "[" + getterName + "]";
                }
                fullObjectName = objectName + "." + getterName;
            }
        }
        if (!fullObjectName.startsWith("$")) {
            fullObjectName = "$" + fullObjectName;
        }
        return fullObjectName;
    }

    private boolean isJavaObjectToExlude(Object objectValue) {
        if (objectValue != null) {
            if (objectValue instanceof IRTFCode) {
                return true;
            }
            Class<?> objectClass = objectValue.getClass();
            if (objectClass != null && objectClass.getPackage() != null) {
                String packageName = objectClass.getPackage().getName();
                for (String excludePackageName : this.excludedPackages) {
                    if (!packageName.startsWith(excludePackageName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isImage(Object objectValue) {
        return objectValue instanceof InputStream;
    }

    protected abstract void startReading();

    protected abstract void endReading();

    protected abstract void addBookmark(String var1, String var2);

    protected abstract void addMergeField(String var1, boolean var2, String var3, boolean var4);
}

