/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rtf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import net.sourceforge.rtf.IRTFDocumentParser;
import net.sourceforge.rtf.IRTFDocumentTransformer;
import net.sourceforge.rtf.ITemplateEngine;
import net.sourceforge.rtf.context.DigesterRTFContextFields;
import net.sourceforge.rtf.context.fields.RTFContextFields;
import net.sourceforge.rtf.document.RTFDocument;
import net.sourceforge.rtf.document.transformer.config.DigesterTransformerConfig;
import net.sourceforge.rtf.document.transformer.config.TransformerConfig;
import net.sourceforge.rtf.template.IContext;
import org.xml.sax.SAXException;

public class RTFTemplate {
    private InputStream rtfSourceInputStream;
    private Reader rtfSourceReader;
    private static TransformerConfig defaultTransformerConfig;
    private RTFDocument transformedDocument;
    private IRTFDocumentParser parser;
    private ITemplateEngine templateEngine;
    private InputStream xmlFields;
    private IRTFDocumentTransformer transformer;
    private TransformerConfig transformerConfig;

    public void initializeContext() {
        this.templateEngine.initializeContext();
    }

    public IContext getContext() {
        return this.templateEngine.getContext();
    }

    public void setGlobalContext(IContext globalContext) {
        this.templateEngine.setGlobalContext(globalContext);
    }

    public void setTemplate(File rtfSourceFile) throws FileNotFoundException {
        this.rtfSourceInputStream = null;
        this.transformedDocument = null;
        this.rtfSourceReader = new FileReader(rtfSourceFile);
    }

    public void setTemplate(InputStream template) {
        this.rtfSourceInputStream = template;
        this.transformedDocument = null;
        this.rtfSourceReader = null;
    }

    public void setTemplate(Reader template) {
        this.rtfSourceReader = template;
        this.transformedDocument = null;
        this.rtfSourceInputStream = null;
    }

    public void put(String key, Object value) {
        this.templateEngine.put(key, value);
    }

    public RTFDocument merge(String file) throws Exception {
        this.transformAndSetTemplate();
        this.templateEngine.merge(file);
        return this.transformedDocument;
    }

    public RTFDocument merge(File file) throws Exception {
        this.transformAndSetTemplate();
        this.templateEngine.merge(file);
        return this.transformedDocument;
    }

    public RTFDocument merge(Writer writer) throws Exception {
        this.transformAndSetTemplate();
        this.templateEngine.merge(writer);
        return this.transformedDocument;
    }

    public void setDefaultFormat(Class clazz, Format format) {
        this.templateEngine.setDefaultFormat(clazz, format);
    }

    public RTFDocument transform() throws IOException, SAXException {
        if (this.parser == null) {
            throw new IOException("RTFDocumentParser must be defined. Use setParser method to set it.");
        }
        if (this.transformer == null) {
            throw new IOException("RTFDocumentTransformer must be defined. Use setTransformer method to set it.");
        }
        RTFDocument document = null;
        if (this.rtfSourceInputStream != null) {
            this.parser.parse(this.rtfSourceInputStream);
        } else {
            this.parser.parse(this.rtfSourceReader);
        }
        document = this.parser.getRTFDocument();
        if (document == null) {
            throw new IOException("Error : impossible to get RTF document of source file RTF ");
        }
        this.transformer.setTransformerConfig(this.transformerConfig);
        if (this.xmlFields == null) {
            this.transformedDocument = this.transformer.transform(document, this.templateEngine.getContext());
        } else {
            RTFContextFields rtfContextFields = DigesterRTFContextFields.getRTFContextFields(this.xmlFields);
            this.transformedDocument = this.transformer.transform(document, rtfContextFields);
        }
        return this.transformedDocument;
    }

    private void transformAndSetTemplate() throws IOException, SAXException {
        if (this.transformedDocument == null) {
            this.transformedDocument = this.transform();
        }
        Reader transformedReader = this.transformedDocument.getReader();
        this.templateEngine.setTemplate(transformedReader);
    }

    public ITemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(ITemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public IRTFDocumentTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(IRTFDocumentTransformer transformer) {
        this.transformer = transformer;
    }

    public void setTransformerConfig(TransformerConfig transformerConfig) {
        this.transformerConfig = transformerConfig;
    }

    public TransformerConfig getTransformerConfig() {
        if (this.transformerConfig == null) {
            this.transformerConfig = defaultTransformerConfig;
        }
        return this.transformerConfig;
    }

    public InputStream getXmlFields() {
        return this.xmlFields;
    }

    public void setXmlFields(InputStream xmlFields) {
        this.xmlFields = xmlFields;
    }

    public void setTransformedDocument(RTFDocument transformedDocument) {
        this.transformedDocument = transformedDocument;
    }

    public RTFDocument getTransformedDocument() {
        return this.transformedDocument;
    }

    public int getGroupByPerPageBreak() {
        if (this.transformer != null) {
            return this.transformer.getGroupByPerPageBreak();
        }
        return -1;
    }

    public void setGroupByPerPageBreak(int groupByPerPageBreak) {
        if (this.transformer != null) {
            this.transformer.setGroupByPerPageBreak(groupByPerPageBreak);
        }
    }

    public IRTFDocumentParser getParser() {
        return this.parser;
    }

    public void setParser(IRTFDocumentParser parser) {
        this.parser = parser;
    }

    public boolean isCircularReferences() {
        if (this.transformer != null) {
            return this.transformer.isCircularReferences();
        }
        return false;
    }

    public void setCircularReferences(boolean circularReferences) {
        if (this.transformer != null) {
            this.transformer.setCircularReferences(circularReferences);
        }
    }

    static {
        try {
            defaultTransformerConfig = DigesterTransformerConfig.getTransformerConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

