/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.lang;

import de.riwagis.util.lang.VersionTokenizer;
import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    public static final VersionComparator DEFAULT_VERSIONCOMPARATOR = new VersionComparator();

    public boolean equals(String o1, String o2) {
        return this.compare(o1, o2) == 0;
    }

    @Override
    public int compare(String version1, String version2) {
        String suffix2;
        int number2;
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        VersionTokenizer tokenizer1 = new VersionTokenizer(version1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version2);
        while (tokenizer1.MoveNext()) {
            boolean empty2;
            String suffix1;
            int number1;
            if (!tokenizer2.MoveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.MoveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.MoveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.MoveNext());
            return 0;
        }
        return 0;
    }
}

